import QtQuick 2.3
import QtQuick.Controls 2.0
import QtGraphicalEffects 1.0

import com.viavi.style 1.0

ComboBox {
    id: root

    implicitHeight: ViaviStyle.layout.buttonHeight
    implicitWidth: ViaviStyle.layout.buttonWidth

    padding: ViaviStyle.layout.smallMargin


    textRole: "text"

    background: Rectangle {
        width: root.width
        height: root.height

        color: root.pressed ? ViaviStyle.colors.selectedBackgroundColor :  ViaviStyle.colors.contentBackgroundColor
        border.color: enabled ? ViaviStyle.colors.activeColor : ViaviStyle.colors.disabledItemColor
        border.width: ViaviStyle.layout.borderSize
    }

    contentItem: Text {
        text: root.displayText

        width: root.width
        height: root.height
        x: ViaviStyle.layout.smallMargin

        verticalAlignment: Text.AlignVCenter

        font: ViaviStyle.layout.activeBoldTextFont

        color: root.enabled ? ViaviStyle.colors.mainInfoColor : ViaviStyle.colors.disabledItemColor
    }

    delegate: ItemDelegate {
        id: delegateItem
        height: ViaviStyle.layout.menuLineHeight
        width: root.width
        contentItem: Text{
            anchors.horizontalCenter: parent.horizontalCenter
            x: ViaviStyle.layout.smallMargin

            verticalAlignment: Text.AlignVCenter

            text: model.text !== undefined ? model.text : modelData
            font: index === root.currentIndex ? ViaviStyle.layout.activeBoldTextFont :
                                                ViaviStyle.layout.activeTextFont

            color: ViaviStyle.colors.mainInfoColor
        }
        hoverEnabled: true
        background: Rectangle{
            anchors.fill: parent
            color: {
                delegateItem.pressed ? ViaviStyle.colors.selectedBackgroundColor :
                            (hovered ? ViaviStyle.colors.pageBackgroundColor : ViaviStyle.colors.contentBackgroundColor)
            }
        }
    }

    indicator: Item {
        width: root.width
        height: root.height

        ColorImage {
            id: selectionMarker

            width: ViaviStyle.layout.veryLargeMargin
            height: ViaviStyle.layout.veryLargeMargin

            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layout.smallMargin
            anchors.verticalCenter: parent.verticalCenter

            source: ViaviStyle.images.iconMenu
            fillMode: Image.PreserveAspectFit
            transform: Rotation {
                origin.x: selectionMarker.width / 2
                origin.y: selectionMarker.height / 2
                angle: popup.visible ? 180 : 0
            }

            smooth: true
            color: root.enabled ? ViaviStyle.colors.activeColor : ViaviStyle.colors.disabledItemColor
        }

    }

    popup: Popup {
        y: root.height
        width: root.width
        implicitHeight: contentItem.implicitHeight + padding * 2
        padding: ViaviStyle.layout.borderSmallWidth

        contentItem: ListView {
            clip: true
            implicitHeight: contentHeight
            model: root.popup.visible ? root.delegateModel : null
            delegate: root.delegate
            currentIndex: root.highlightedIndex

            ScrollIndicator.vertical: ScrollIndicator { }
        }
    }
}

