import QtQuick 2.9
import QtQuick.Templates 2.2 as T
import com.viavi.style 1.0

T.TextField {
    id: root

    property color backgroundColor: ViaviStyle.theme.clickableBackground
    property color backgroundColorDisabled: ViaviStyle.theme.clickableBackgroundDisabled
    property color textColor: ViaviStyle.theme.clickableForeground
    property color textColorDisabled: ViaviStyle.theme.clickableForegroundDisabled

    property color borderColor: ViaviStyle.theme.border
    property color borderColorFocused: ViaviStyle.theme.borderFocused
    property int borderWidth: ViaviStyle.layout.borderWidth

    property alias fontHeight: fontMetrics.height

    font: ViaviStyle.layout.mediumFont
    color: enabled ? root.textColor : root.textColorDisabled
    text: ""

    implicitWidth: backgroundRect.implicitWidth
    implicitHeight: backgroundRect.implicitHeight

    padding: ViaviStyle.layout.mediumMargin

    FontMetrics {
        id: fontMetrics
        font: root.font
    }

    background: Rectangle {
        id: backgroundRect

        implicitWidth: ViaviStyle.layout.defaultTextFieldWidth
        implicitHeight: fontMetrics.height + root.padding * 2

        border.color: root.focus && root.enabled ? root.borderColorFocused : root.borderColor
        border.width: borderWidth

        color: root.enabled ? root.backgroundColor : root.backgroundColorDisabled
    }
}
