import QtQuick 2.3
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import '..'

ComboBox {
    id: root

    implicitHeight: ViaviStyle.layout.buttonHeight
    implicitWidth: height * 4

    height: implicitHeight
    width: implicitWidth

    padding: ViaviStyle.layout.smallMargin

    background: Rectangle{
        width: root.width
        height: root.height

        color: root.pressed ? ViaviStyle.colors.checkedItemColor
                            : ViaviStyle.colors.contentBackgroundColor
        border.color: ViaviStyle.colors.activeColor
        border.width: ViaviStyle.layout.borderSize * 3
    }

    contentItem: Text {
        text: root.displayText

        width: root.width
        height: root.height

        x: ViaviStyle.layout.veryLargeMargin
        verticalAlignment: Text.AlignVCenter

        font: ViaviStyle.layout.veryLargeFont
        color: ViaviStyle.colors.mainInfoColor
    }

    popup: Popup {
        y: root.height - 1
        width: root.width
        implicitHeight: contentItem.implicitHeight
        padding: 1

        contentItem: ListView {
            clip: true
            implicitHeight: contentHeight
            model: root.popup.visible ? root.delegateModel : null
            currentIndex: root.highlightedIndex

            ScrollIndicator.vertical: ScrollIndicator { }
        }

        background: Rectangle {
            border.color: ViaviStyle.colors.activeColor
            border.width: ViaviStyle.layout.borderSize * 3
        }
    }

    delegate: ItemDelegate {
        id: delegateItem

        width: root.width
        height: root.height

        highlighted: root.highlightedIndex === index

        contentItem: Text{
            anchors.horizontalCenter: parent.horizontalCenter

            x: ViaviStyle.layout.veryLargeMargin
            verticalAlignment: Text.AlignVCenter

            text: model.text
            font: ViaviStyle.layout.veryLargeFont

            color: delegateItem.highlighted ? ViaviStyle.colors.activeColor
                                        : ViaviStyle.colors.mainInfoColor
        }

        background: Rectangle {
            anchors.fill: parent
            color: delegateItem.pressed || delegateItem.highlighted
                                        ? ViaviStyle.colors.checkedItemColor
                                        : ViaviStyle.colors.contentBackgroundColor
        }
    }

    indicator: Item{
        width: root.width
        height: root.height

        ColorImage {
            id: comboboxIndicator

            height: parent.height * 0.5

            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layout.largeMargin
            anchors.verticalCenter: parent.verticalCenter

            source: FiberStyle.images.iconDropDownList
            fillMode: Image.PreserveAspectFit
            smooth: true

            color: ViaviStyle.colors.activeColor

            transform: Rotation{
                origin.x: comboboxIndicator.width / 2
                origin.y: comboboxIndicator.height / 2
                angle: popup.visible ? -90 : 90
            }
        }
    }
}
