import QtQuick 2.5
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0

Rectangle {
    id: menuContainer

    readonly property int nrOfMenuColumns: 4
    property int menuColumnWidth: width / nrOfMenuColumns
    readonly property int nrOfChoiceColumns: 6
    property int choiceColumnWidth: width / nrOfChoiceColumns
    property int choiceColumnMaxWidth: width - menuColumnWidth

    readonly property real indicatorHeight: ViaviStyle.layout.imageButtonHeight * 0.6
    property int firstMenuYAlign: 0
    anchors.fill: parent

    property Menu prevLevelMenu: null

    onVisibleChanged: {
        if (visible) {
            firstLevelList.forceActiveFocus()
        }
        else {
            if (prevLevelMenu) {
                prevLevelMenu.forceActiveFocus()
            }
        }
    }


    color: ViaviStyle.colors.transparentBackgroundColor

    MouseArea{
        anchors.fill: parent
        
        onClicked:{
            menu_act_closeMenu.invoke()
        }
    }

    function alignMenuYOnScreen(prevYAlign, height) {
        if(menuContainer.height > prevYAlign + height) {
            return Math.max(0, prevYAlign)
        }
        else {
            var offset = prevYAlign - (menuContainer.height - height)
            var nrOfIndexes =  (offset / ViaviStyle.layout.menuLineHeight) | 0
            if(offset % ViaviStyle.layout.menuLineHeight != 0) {
                nrOfIndexes += 1
            }
            return Math.max(0, prevYAlign - nrOfIndexes * ViaviStyle.layout.menuLineHeight)
        }
    }

    function getMenuHeight( parentHeight, contentHeight ) {
        if( contentHeight > parentHeight )
        {
            return parentHeight - 2 * menuContainer.indicatorHeight
        }
        else return contentHeight
    }

    MenuScrollIndicator
    {
        visible: firstLevelMenuItem.level1List.visible && !firstLevelMenuItem.level1List.atYBeginning

        anchors.top: parent.top
        anchors.left: firstLevelMenuItem.left
        anchors.right: firstLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth

        isUpIndicator: true
    }

    Item {
        id: firstLevelMenuItem

        property alias level1List: firstLevelList

        width: menuColumnWidth
        
        height: getMenuHeight( parent.height, firstLevelList.contentHeight )

        y: parent.height < firstLevelList.contentHeight ? menuContainer.indicatorHeight:
            alignMenuYOnScreen(menuContainer.firstMenuYAlign - ViaviStyle.layout.menuLineHeight * (menu_res_firstNonActionListItem.value + 1), height)

        anchors.right: parent.right

        MenuOptionList
        {
            id: firstLevelList

            menuContainer: firstLevelMenuItem
            model: menu_res_menuLevelLists_0.value
            nextLevelMenu: secondLevelMenu

            choiceColumnWidth: menuContainer.choiceColumnWidth
            choiceMaxColumnWidth: menuContainer.choiceColumnMaxWidth

            Keys.onEscapePressed: {
                focus = false
                menu_act_closeMenu.invoke()
            }
            Keys.onRightPressed: {
                focus = false
                menu_act_closeMenu.invoke()
            }
        }
    }

    MenuScrollIndicator
    {
        visible: firstLevelMenuItem.level1List.visible && !firstLevelMenuItem.level1List.atYEnd

        anchors.bottom: parent.bottom
        anchors.left: firstLevelMenuItem.left
        anchors.right: firstLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth
    }


    MenuScrollIndicator
    {
        visible: secondLevelMenuItem.level2List.visible && !secondLevelMenuItem.level2List.atYBeginning

        anchors.top: parent.top
        anchors.left: secondLevelMenuItem.left
        anchors.right: secondLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth

        isUpIndicator: true
    }

    Item {
        id: secondLevelMenuItem

        property alias level2List: secondLevelList

        width: menuColumnWidth

        height: getMenuHeight( parent.height, secondLevelList.contentHeight )

        y: parent.height < secondLevelList.contentHeight ? menuContainer.indicatorHeight:
            alignMenuYOnScreen(firstLevelMenuItem.y + ViaviStyle.layout.menuLineHeight * menu_res_selectedIndexPerMenu_0.value, height)

        anchors.right: firstLevelMenuItem.left

        Menu {
            id: secondLevelMenu

            width: parent.width
            height: parent.height

            closePolicy: Popup.NoAutoClose

            background: Rectangle {
                border.width: 0
            }

            contentItem: MenuOptionList {
                id: secondLevelList

                menuContainer: secondLevelMenuItem
                model: menu_res_menuLevelLists_1.value
                prevLevelMenu: firstLevelList
                nextLevelMenu: thirdLevelMenu

                choiceColumnWidth: menuContainer.choiceColumnWidth
                choiceMaxColumnWidth: menuContainer.choiceColumnMaxWidth

                Keys.onRightPressed: secondLevelMenu.close()
            }
        }
    }

    MenuScrollIndicator
    {
        visible: secondLevelMenuItem.level2List.visible && !secondLevelMenuItem.level2List.atYEnd

        anchors.bottom: parent.bottom
        anchors.left: secondLevelMenuItem.left
        anchors.right: secondLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth
    }

    MenuScrollIndicator
    {
        visible: thirdLevelMenuItem.level3List.visible && !thirdLevelMenuItem.level3List.atYBeginning

        anchors.top: parent.top
        anchors.left: thirdLevelMenuItem.left
        anchors.right: thirdLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth

        isUpIndicator: true
    }

    Item {
        id: thirdLevelMenuItem

        property alias level3List: thirdLevelList

        width: menuColumnWidth
        height: getMenuHeight( parent.height, thirdLevelList.contentHeight )

        y: parent.height < thirdLevelList.contentHeight ? menuContainer.indicatorHeight:
            alignMenuYOnScreen(secondLevelMenuItem.y + ViaviStyle.layout.menuLineHeight * menu_res_selectedIndexPerMenu_1.value, height)
        anchors.right: secondLevelMenuItem.left

        Menu {
            id: thirdLevelMenu

            width: parent.width
            height: parent.height

            closePolicy: Popup.NoAutoClose

            background: Rectangle {
                border.width: 0
            }

            contentItem: MenuOptionList {
                id: thirdLevelList

                menuContainer: thirdLevelMenuItem
                model: menu_res_menuLevelLists_2.value
                prevLevelMenu: secondLevelMenu
                nextLevelMenu: forthLevelMenu

                choiceColumnWidth: menuContainer.choiceColumnWidth
                choiceMaxColumnWidth: menuContainer.choiceColumnMaxWidth

                Keys.onRightPressed: thirdLevelMenu.close()
            }
        }
    }

    MenuScrollIndicator
    {
        visible: thirdLevelMenuItem.level3List.visible && !thirdLevelMenuItem.level3List.atYEnd

        anchors.bottom: parent.bottom
        anchors.left: thirdLevelMenuItem.left
        anchors.right: thirdLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth
    }

    MenuScrollIndicator
    {
        visible: forthLevelMenuItem.level4List.visible && !forthLevelMenuItem.level4List.atYBeginning

        anchors.top: parent.top
        anchors.left: forthLevelMenuItem.left
        anchors.right: forthLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth

        isUpIndicator: true
    }

    Item {
        id: forthLevelMenuItem

        property alias level4List: forthLevelList

        width: menuColumnWidth
        height: getMenuHeight( parent.height, forthLevelList.contentHeight )

        y: parent.height < forthLevelList.contentHeight ? menuContainer.indicatorHeight:
            alignMenuYOnScreen(thirdLevelMenuItem.y + ViaviStyle.layout.menuLineHeight * menu_res_selectedIndexPerMenu_2.value, height)
        x: Math.max(0, thirdLevelMenuItem.x - width)


        Menu {
            id: forthLevelMenu

            width: parent.width
            height: parent.height

            closePolicy: Popup.NoAutoClose

            background: Rectangle {
                border.width: 0
            }

            contentItem: MenuOptionList {
                id: forthLevelList

                menuContainer: forthLevelMenuItem
                model: menu_res_menuLevelLists_3.value
                prevLevelMenu: thirdLevelMenu
                nextLevelMenu: null

                choiceColumnWidth: menuContainer.choiceColumnWidth
                choiceMaxColumnWidth: menuContainer.choiceColumnMaxWidth

                Keys.onRightPressed: forthLevelMenu.close()
            }
        }
    }

    MenuScrollIndicator
    {
        visible: forthLevelMenuItem.level4List.visible && !forthLevelMenuItem.level4List.atYEnd

        anchors.bottom: parent.bottom
        anchors.left: forthLevelMenuItem.left
        anchors.right: forthLevelMenuItem.right

        height: menuContainer.indicatorHeight
        width: menuColumnWidth
    }
}


