from .ioctlutil import *
import fcntl
import sys
import os,errno

cUTS_POWER_METER_IO_MAGIC = 0xDC



_POWERMETER_ON_UTS_POWER_METER      = IOW(cUTS_POWER_METER_IO_MAGIC, 0, "ii")
_POWERMETER_OFF_UTS_POWER_METER     = IO(cUTS_POWER_METER_IO_MAGIC, 1)
_FREQUENCY_ON_UTS_POWER_METER       = IO(cUTS_POWER_METER_IO_MAGIC, 2)
_FREQUENCY_OFF_UTS_POWER_METER      = IO(cUTS_POWER_METER_IO_MAGIC, 3)
_READ_POWER_UTS_POWER_METER         = IOR(cUTS_POWER_METER_IO_MAGIC, 4,"LLi")
_READ_FREQUENCY_UTS_POWER_METER     = IOR(cUTS_POWER_METER_IO_MAGIC, 5,"L")
_MODIFY_GAIN_UTS_POWER_METER        = IOW(cUTS_POWER_METER_IO_MAGIC, 6,"L")
_POWERMETER_INT_ON_UTS_POWER_METER  = IOW(cUTS_POWER_METER_IO_MAGIC, 7,"ii")


class _Pwm_Conf(ctypes.Structure):
    _fields_ = [
        ('Pwm_Number_Value_For_Average', ctypes.c_int),
        ('Pwm_Gain_Auto', ctypes.c_int)
        ]

class _Pwm_Power_Gain(ctypes.Structure):
    _fields_ = [
        ('Pwm_Power', ctypes.c_ulong),
        ('Pwm_Gain', ctypes.c_ulong),
        ('Pwm_Number_Value_For_Average', ctypes.c_int)
        ]

class Powermeter(object):
    '''
    Class to use IOCTL from driver Power_meter
    '''

    def __init__(self, device):
        self.__dev = device
        self.__fd = None

    def open(self):
        if self.__fd is None:
            self.__fd = open(self.__dev,"rb")

    def close(self):
        if self.__fd is not None:
            self.__fd.close()
            self.__fd = None

    def On(self,average,gain_auto):
        arg = _Pwm_Conf()
        arg.Pwm_Number_Value_For_Average = average
        arg.Pwm_Gain_Auto = gain_auto
        rc = fcntl.ioctl(self.__fd, _POWERMETER_ON_UTS_POWER_METER, arg)

    def Off(self):
        fcntl.ioctl(self.__fd, _POWERMETER_OFF_UTS_POWER_METER, 0)

    def getPower(self):
        arg = _Pwm_Power_Gain()
        rc = fcntl.ioctl(self.__fd, _READ_POWER_UTS_POWER_METER, arg)
        return arg.Pwm_Power

    def Modify_Gain(self, gain):
        arg = ctypes.c_long()
        arg = gain
        fcntl.ioctl(self.__fd, _MODIFY_GAIN_UTS_POWER_METER, arg)

    def Frequency_on(self):
        fcntl.ioctl(self.__fd, _FREQUENCY_ON_UTS_POWER_METER)


    def Frequency_off(self):
        fcntl.ioctl(self.__fd, _FREQUENCY_OFF_UTS_POWER_METER)

    def getFrequency(self):
        freq = ctypes.c_uint()
        fcntl.ioctl(self.__fd, _FREQUENCY_OFF_UTS_POWER_METER, freq)
