#!/bin/sh

exec >> /var/tmp/snmp_preinitlog.txt 2>&1

DEVICE_MODEL_5000="Otu5000"
DEVICE_MODEL_8000="Otu8kv2"
DEVICE_MODEL_FTH_9000="FTH-9000"
DEVICE_MODEL_FTH_7000="FTH-7000"
DEVICE_MODEL_UNK="Otu"

SERIAL_MODEL_5000="EBAJ-"
SERIAL_MODEL_8000=""
SERIAL_MODEL_9000="EBAP-"
SERIAL_MODEL_7000="EBAU-"

#
#  Retrieve data from getindoversion Otu
#  Used to extract model type and version number 
sys_otu_info=$(/sbin/getinfoversion Otu)
if [ $? != 0 ]; then
    sys_otu_info=""
fi
echo "otuinfoversion $sys_otu_info"

#
#  Extract the OTU model type and FW version number
#  from the result of getinfoversion Otu
otu_device_model=$(awk -F ';' '{print $1}' <<< $sys_otu_info)
otu_fw_number=$(awk -F ';' '{print $4}' <<< $sys_otu_info)

#  Retrieve OTU serial Number
#  Add EBAJ- pretag for OTU-5000
sys_sernum=$("/sbin/getserialnb")
case "$otu_device_model" in
	"$DEVICE_MODEL_5000")
		otu_serial_number="${SERIAL_MODEL_5000}${sys_sernum}"
		echo "OTU serial Number = $otu_serial_number"
		;;
	"$DEVICE_MODEL_FTH_9000")
		otu_serial_number="${SERIAL_MODEL_9000}${sys_sernum}"
		echo "OTU serial Number = $otu_serial_number"
		;;
	"$DEVICE_MODEL_FTH_7000")
		otu_serial_number="${SERIAL_MODEL_7000}${sys_sernum}"
		echo "OTU serial Number = $otu_serial_number"
		;;
	*)
		otu_serial_number="${SERIAL_MODEL_8000}${sys_sernum}"
		echo "OTU serial Number NoTags = $otu_serial_number"
esac

#
#  OTU Manufacturer is configured to match the object value
#  as coded in the snmp-agent
#
otu_manufacturer="Viavi Solutions"

#
#  Retrieve device name (use system hostname)
otu_device_name=$("/bin/hostname")
echo "hostname = $otu_device_name"

#echo "  Revised sysDescr data = $otu_device_model, $otu_fw_number, $otu_manufacturer, $otu_device_name, $otu_serial_number, Linux $(uname -r) kernel " 
echo "Revised sysDescr data = $otu_device_model, $otu_fw_number, $otu_manufacturer, $otu_device_name, $otu_serial_number, Linux $(uname -r) kernel " 

#
#  remove any sysDescr and sysObjetID override directives
#  from the current /etc/snmp/snmpd.conf file
#
sed -i '/override sysDescr/d' /etc/snmp/snmpd.conf
sed -i '/override sysObjectID/d' /etc/snmp/snmpd.conf

#
#  Apply override directives for sysDescr and sysObejectID
#  into /etc/snmp/snmpd.conf
#
echo "override sysDescr.0 octet_str \"$otu_device_model,$otu_fw_number,$otu_manufacturer,$otu_device_name,$otu_serial_number,Linux $(uname -r)\"" >> /etc/snmp/snmpd.conf
echo "override sysObjectID.0 object_id \"1.3.6.1.4.1.35873.5.1.2.1.1.4\"" >> /etc/snmp/snmpd.conf

echo "$0 ----------------------- snmpd.conf updated"
exit 0

