#!/bin/bash

# looking for dts name inside uevent to find the proper gpiochip
# Then get the IO base address
PATH_TO_GPIO=$(grep -l gpio@22 /sys/class/gpio/gpiochip*/device/uevent | head -n 1)
[ "$PATH_TO_GPIO" == "" ] && exit 1

PATH_TO_GPIO=$(dirname "${PATH_TO_GPIO}")
cd "$PATH_TO_GPIO" || exit 1
cd ..
BASE_GPIO=$(cat base)
GPIO_PROGRAM_FPGA=$((BASE_GPIO + 13 ))

if [ ! -d "/sys/class/gpio/gpio${GPIO_PROGRAM_FPGA}" ] ; then
    echo "$GPIO_PROGRAM_FPGA" > /sys/class/gpio/export
fi

echo out > /sys/class/gpio/gpio${GPIO_PROGRAM_FPGA}/direction
echo 0 > /sys/class/gpio/gpio${GPIO_PROGRAM_FPGA}/value

sleep 0.1

exit 0