#!/bin/bash
# /usr/bin/otu_local_mode.sh

PATH="$PATH:/usr/bin:/bin:/usr/sbin:/sbin"

LOG="/var/log/nm2_1.txt"

OTH="OTH"

function my_logger
{
  if $(readlink /sbin/init | grep -q systemd); then
      echo "$*" | systemd-cat
  else
    echo "$(date '+%Y %m %d %H:%M:%S') - $*" >> $LOG
  fi
}

eth_down=true

SSH_NO_CONSOLE=$(fw_printenv -n ssh_strong_no_console)
if [[ "$SSH_NO_CONSOLE" == "true" ]]; then
	[[ -f /tmp/otu_eth_down ]] && eth_down="$( cat /tmp/otu_eth_down )"
fi

case $1 in
"start")
	# si on n'est pas en SSH_NO_CONSOLE sinon si les deux interfaces, eth0 et ethbackup, sont déconnectées
	if [[ "$eth_down" == "true" ]]; then		 
		my_logger "$0 - start ethlocal and dhcpd"
		
		# montage de l'interface ethlocal
		ifconfig ethlocal 192.168.1.1 up
		
		# demarrage du serveur dhcpd
		dhcpd -q -cf /etc/dhcp/dhcpd_otu_local.conf -pf /var/run/dhcpd_otu_local.pid ethlocal
	fi
	;;

"stop")
	# arret du serveur dhcpd
	pkill -F /var/run/dhcpd_otu_local.pid
	rm -f /var/run/dhcpd_otu_local.pid 
	
	# desactivation de l'interface ethlocal (elle existe mais n'a plus d'adresse)
	ifconfig ethlocal 0.0.0.0 up 
	
	my_logger "$0 - stop ethlocal and dhcpd"
	;;

*)
	;;
esac

