#! /bin/sh

VER_FILE_PATH_OLD="/acterna/release/bin"
VER_FILE_PATH_NEW="/etc/release/version"

FO_VER_FILE_NAME="Fiber_Optic.ver"
ISU_VER_FILE_NAME="Isu.ver"

function read_version_file_version()
{
	[ "$#" -ne "1" ] && echo "ERROR: ${FUNCNAME} - Please check the number of arguments (1 required)" && return -1
	VERSION_FILE="$1"

	read_version_file_version_return=$(grep -E "^(V)?[0-9]+\.[0-9]+(\.[0-9]+)?" ${VERSION_FILE})
	
	echo ${read_version_file_version_return}
	return 0
}

function read_app_version()
{
	[ "$#" -ne "1" ] && echo "ERROR: ${FUNCNAME} - Please check the number of arguments (1 required: 'ISU' or 'FO')" && return -1
	APP_NAME="$1"

	VER_FILE_NAME=""
	if [ "${APP_NAME}" = "FO" ]
	then
		VER_FILE_NAME="${FO_VER_FILE_NAME}"
	elif [ "${APP_NAME}" = "ISU" ] 
	then
		VER_FILE_NAME="${ISU_VER_FILE_NAME}"
	else
		echo "ERROR: APP Name invalid (must be 'ISU' or 'FO')"
		return -1
	fi

	VERSION=""
	if [ -f "${VER_FILE_PATH_NEW}/${VER_FILE_NAME}" ]
	then
#		echo "Version file found in new path"
		VERSION=$(read_version_file_version "${VER_FILE_PATH_NEW}/${VER_FILE_NAME}")
	elif [ -f "${VER_FILE_PATH_OLD}/${VER_FILE_NAME}" ]
	then
#		echo "Version file found in old path"
		VERSION=$(read_version_file_version "${VER_FILE_PATH_OLD}/${VER_FILE_NAME}")
	else
		echo "ERROR: Version file could not be found !"
		return -1
	fi

	[ -z "${VERSION}" ] && echo "ERROR: Could not read the version number" && return -1

	echo ${VERSION}
	return 0
}

read_app_version $@

