#!/bin/bash

# Fix some potential CAL partition issues
mountpoint -q /cal && umount /cal
fsck.ext4 -y /dev/mmcblk0p2
mount /dev/mmcblk0p2 /cal

# Remove the rescue mode flag to avoid falling in rescue mode at next boot
rm -f /cal/rescue_flag

# Remove some CAL partition ext4 attributes that annoys U-Boot
dumpe2fs -h /dev/mmcblk0p2 2>/dev/null | grep metadata_csum -q
if [ $? -eq 0 ]
then
  umount /cal
  e2fsck -f /dev/mmcblk0p2
  tune2fs -f -O ^metadata_csum,^64bit /dev/mmcblk0p2
  mount -o ro /dev/mmcblk0p2 /cal
fi
mount /cal -o remount,ro

exit 0
