#!/bin/bash
# generate base names base|otu

alias showlog='journalctl -b --all -u isu_ona --no-pager'
alias is_rescue='[ -f "/cal/rescue_flag" ] && echo "yes" || echo "no"'
alias is_otu='[ '"$(hexdump /proc/device-tree/board/info-otu-board -n 4 -e '"%d"')"' -ne "0" ] && echo "yes" || echo "no"'

alias ls='ls --color="auto"'
alias ll='ls -lAh'


# Add some colors to the Shell prompt when not on PMulti nor TELNET
colorme() {
    if [ "${EUID}" = "0" ]
    then
        export PS1='\[\033[01;31m\]\h\[\033[01;34m\] \W \$\[\033[00m\] '
    else
        export PS1='\[\033[01;32m\]\u@\h\[\033[01;34m\] \w \$\[\033[00m\] '
    fi
}

if [ ! -e /init -a "$SHELLPROCESS" != "telnetd" ]
then
    # We are not on pmulti nor telnet, enable color
    colorme
fi


source /usr/lib/otu_functions

INFO_OTU_BOARD=$(hexdump /proc/device-tree/board/info-otu-board -n 4 -e '"%d"')
export CFG_PLATFORM_NAME="OTH"
if [[ $INFO_OTU_BOARD -eq 5 ]]; then
    export CFG_MKT_PLATFORM_NAME="FTH-7000"
else
	export CFG_MKT_PLATFORM_NAME="FTH-9000"
fi
export CFG_PLATFORM_HOSTNAME="OTH"
export CFG_PLATFORM_FRIENDLY_NAME="OTH"
export INFO_OTU_BOARD

export "$(systemctl show-environment | grep BUS_SESSION_BUS_ADDRESS)"
