import QtQuick 2.3

import com.viavi.fiberutilui.components 1.0

FiberListPopup {
    id: root

    signal btnOkClicked(int index);
    signal btnCancelClicked();

    delegate: FiberListDelegate{
        id: delegateRoot
        text: model.modelData

        isSelected: root.currentIndex === model.index

        onClicked: {
            root.currentIndex = model.index;
        }
    }

    onCancelClicked: {
        btnCancelClicked()
        root.close()
    }

    onValidateClicked: {
        btnOkClicked(root.currentIndex)
        root.close()
    }
}
