import QtQuick 2.5

import com.viavi.style 1.0


QtObject {
    id: slmUtils

    /* MiniSlm: calculate line size between events */
    function getMiniSlmConnSize ( connectionDistance, totalSlmLength, lineLength, minConnLength )
    {
        var connSize = minConnLength;

        if ( totalSlmLength > 0 && lineLength > 0 && parseFloat (connectionDistance) !== 0.00 )
        {
            connSize += Math.abs(parseFloat (connectionDistance)) * lineLength / totalSlmLength ;
        }

        return connSize;
    }

    /* Schematic: calculate line size between events */
    function getSchematicConnSize ( connectionDistance, totalSlmLength, minConnLength )
    {
        var connSize = minConnLength;

        if ( totalSlmLength > 0 && connectionDistance !== "" && parseFloat (connectionDistance) !== 0.00 )
        {
            connSize += Math.abs(parseFloat (connectionDistance)) / totalSlmLength * 5 * minConnLength ;
        }

        return connSize;
    }
}
