import QtQuick 2.3
import QtQuick.Controls 2.8
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0

import libsetupmenu 1.0

ColumnLayout {

    ViaviMenuLineInputText{
        text: menuOtdr.reportPage.fileSaveIn.name.text
        visible: textData.visible

        textData.text: menuOtdr.reportPage.fileSaveIn.value
        textData.enabled: menuOtdr.reportPage.fileSaveIn.enabled
        textData.visible: menuOtdr.reportPage.fileSaveIn.available

        onTextClicked:{
            menuOtdr.reportPage.fileSaveIn.validateValue()
        }
    }
    Label {
        text: menuOtdr.reportPage.directoryPreview.name.text + ": " + menuOtdr.reportPage.directoryPreview.value
        color: ViaviStyle.colors.secondaryInfoColor
        enabled: menuOtdr.reportPage.directoryPreview.enabled
        visible: menuOtdr.reportPage.directoryPreview.available
    }

    ViaviMenuLineInputTextButton{
        text: menuOtdr.reportPage.fileNaming.name.text
        visible: textData.visible

        textData.text: menuOtdr.reportPage.fileNaming.value
        textData.enabled: menuOtdr.reportPage.fileNaming.enabled
        textData.visible: menuOtdr.reportPage.fileNaming.available

        onTextClicked:{
            menuOtdr.reportPage.fileNaming.validateValue()
        }

        buttonData.text: menuOtdr.reportPage.fileNamingDefault.name.text
        buttonData.enabled: menuOtdr.reportPage.fileNamingDefault.enabled
        buttonData.visible: menuOtdr.reportPage.fileNamingDefault.available
        onButtonClicked: {
            menuOtdr.reportPage.fileNamingDefault.validateValue();
        }
    }


    Label {
        text: menuOtdr.reportPage.filenamePreview.name.text + ": " + menuOtdr.reportPage.filenamePreview.value
        color: ViaviStyle.colors.secondaryInfoColor
        enabled: menuOtdr.reportPage.filenamePreview.enabled
        visible: menuOtdr.reportPage.filenamePreview.available
    }

    MenuSeparator { Layout.fillWidth: true }

    ViaviMenuLineComboBox {
        id: otdrType
        text: menuOtdr.reportPage.otdrType.name.text
        visible: comboBoxData.visible
        comboboxWidth: ViaviStyle.layout.menuTextFieldWidthLarge
        comboBoxData.model: menuOtdr.reportPage.otdrType.multiOptionModel 
        comboBoxData.enabled: menuOtdr.reportPage.otdrType.enabled
        comboBoxData.visible: menuOtdr.reportPage.otdrType.available

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.reportPage.otdrType.validateOption(comboBoxData.currentIndex)
        }
        Connections {
            target: menuOtdr.reportPage.otdrType
            function onSelectedIndexChanged() {
                otdrType.comboBoxData.currentIndex = menuOtdr.reportPage.otdrType.selectedIndex;
            }
        }
    }

    ViaviMenuLineControl {
        text: menuOtdr.reportPage.fileFormatLabel.name.text
        Layout.fillWidth: true
        mainContentFillWidth:true

        mainContentItem: RowLayout {
            id: reportAsRow
            
            Layout.fillWidth: true
            property int itemsCount: 0 + pdfItem.visible ? 1 : 0
                                    + jsonItem.visible ? 1 : 0
                                    + textItem.visible ? 1 : 0

            property int itemsWidth: Math.min(ViaviStyle.layout.menuTextFieldWidth,
                            (reportAsRow.width - reportAsRow.spacing * (reportAsRow.itemsCount - 1)) / reportAsRow.itemsCount)

            ViaviCheckBox { 
                id: pdfItem

                text: menuOtdr.reportPage.pdf.name.text 
                checked: menuOtdr.reportPage.pdf.switch
                enabled: menuOtdr.reportPage.pdf.enabled
                visible: menuOtdr.reportPage.pdf.available
                width: reportAsRow.itemsWidth

                onCheckedChanged:{
                    menuOtdr.reportPage.pdf.validateSwitch(checked);
                }
            }
            ViaviCheckBox { 
                id: jsonItem

                text: menuOtdr.reportPage.json.name.text 
                checked: menuOtdr.reportPage.json.switch
                enabled: menuOtdr.reportPage.json.enabled
                visible: menuOtdr.reportPage.json.available

                width: reportAsRow.itemsWidth

                onCheckedChanged:{
                    menuOtdr.reportPage.json.validateSwitch(checked);
                }
            }
            ViaviCheckBox { 
                id: textItem

                text: menuOtdr.reportPage.txt.name.text 
                checked: menuOtdr.reportPage.txt.switch
                enabled: menuOtdr.reportPage.txt.enabled
                visible: menuOtdr.reportPage.txt.available

                width: reportAsRow.itemsWidth

                onCheckedChanged:{
                    menuOtdr.reportPage.txt.validateSwitch(checked);
                } 
            }
        }
    }

    ViaviMenuLineInputText {
        text: menuOtdr.reportPage.comment.name.text
        visible: textData.visible

        inputTextWidth: ViaviStyle.layout.menuTextFieldWidthVeryLarge

        textData.text: menuOtdr.reportPage.comment.value
        textData.enabled: menuOtdr.reportPage.comment.enabled
        textData.visible: menuOtdr.reportPage.comment.available

        onTextClicked:{
            menuOtdr.reportPage.comment.validateValue()
        }
    }

    ViaviMenuLineSwitch_YesNo {
        text: menuOtdr.reportPage.autoSaveResults.name.text
        checked: menuOtdr.reportPage.autoSaveResults.switch
        enabled: menuOtdr.reportPage.autoSaveResults.enabled
        visible: menuOtdr.reportPage.autoSaveResults.available

        onSgnSwitch: {
            menuOtdr.reportPage.autoSaveResults.validateSwitch(value)
        }
    }

    ViaviMenuLineSwitch_YesNo {
        text: menuOtdr.reportPage.confirmResultsAlarmFail.name.text
        checked: menuOtdr.reportPage.confirmResultsAlarmFail.switch
        enabled: menuOtdr.reportPage.confirmResultsAlarmFail.enabled
        visible: menuOtdr.reportPage.confirmResultsAlarmFail.available

        onSgnSwitch: {
            menuOtdr.reportPage.confirmResultsAlarmFail.validateSwitch(value)
        }
    }

    MenuSeparator { Layout.fillWidth: true }

    ViaviMenuLineComboBox {
        id: reportLayout
        text: menuOtdr.reportPage.reportLayout.name.text
        visible: comboBoxData.visible

        comboBoxData.model: menuOtdr.reportPage.reportLayout.multiOptionModel 
        comboBoxData.enabled: menuOtdr.reportPage.reportLayout.enabled
        comboBoxData.visible: menuOtdr.reportPage.reportLayout.available

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.reportPage.reportLayout.validateOption(comboBoxData.currentIndex)
        }
        Connections {
            target: menuOtdr.reportPage.reportLayout
            function onSelectedIndexChanged() {
                reportLayout.comboBoxData.currentIndex = menuOtdr.reportPage.reportLayout.selectedIndex;
            }
        }
    }

    ViaviMenuLineInputText {
        text: menuOtdr.reportPage.reportNamePreview.name.text
        visible: textData.visible

        textData.text: menuOtdr.reportPage.reportNamePreview.value
        textData.enabled: menuOtdr.reportPage.reportNamePreview.enabled
        textData.visible: menuOtdr.reportPage.reportNamePreview.available

        onTextClicked:{
            menuOtdr.reportPage.reportNamePreview.validateValue()
        }
    }

    ViaviMenuLineSwitch_YesNo {
        text: menuOtdr.reportPage.includeMicroscope.name.text
        checked: menuOtdr.reportPage.includeMicroscope.switch
        enabled: menuOtdr.reportPage.includeMicroscope.enabled
        visible: menuOtdr.reportPage.includeMicroscope.available
        
        onSgnSwitch: {
            menuOtdr.reportPage.includeMicroscope.validateSwitch(value)
        }
    }
}

