import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.3

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

import libsetupmenu 1.0


SetupLayout {
    id: root

    titleContainerSpacing: 0

    property string qmlDir: '/acterna/release/ste/qml/'

    PageButton {
        id: generalButton
        name: menuOtdr.generalPage.name.text
        visible: menuOtdr.generalPage.available
        pageQmlDir: qmlDir
        pageQmlName: "Setup_ExpertOTDR_General.qml"
        Layout.fillWidth: true
    }
    PageButton {
        id: acquisitionButton
        name: menuOtdr.acquisitionPage.name.text
        visible: menuOtdr.acquisitionPage.available
        pageQmlDir: qmlDir
        pageQmlName: "Setup_ExpertOTDR_Acquisition.qml"
        Layout.fillWidth: true
    }
    PageButton {
        id: alarmsButton
        name: menuOtdr.alarmsPage.name.text
        visible: menuOtdr.alarmsPage.available
        pageQmlDir: qmlDir
        pageQmlName: "Setup_ExpertOTDR_Alarms.qml"
        Layout.fillWidth: true
    }
    PageButton {
        id: linkButton
        name: menuOtdr.linkPage.name.text
        visible: menuOtdr.linkPage.available
        pageQmlDir: qmlDir
        pageQmlName: "Setup_ExpertOTDR_Link.qml"
        Layout.fillWidth: true
    }
    PageButton {
        id: reportButton
        name: menuOtdr.reportPage.name.text
        visible: menuOtdr.reportPage.available
        pageQmlDir: qmlDir
        pageQmlName: "Setup_ExpertOTDR_Report.qml"
        Layout.fillWidth: true
    }

    PageButton {
        id: displayButton
        name: menuOtdr.displayPage.name.text
        visible: menuOtdr.displayPage.available
        pageQmlDir: qmlDir
        pageQmlName: "Setup_ExpertOTDR_Display.qml"
        Layout.fillWidth: true
    }

    Item {
        id: spacer
        Layout.fillHeight: true
    }

    ViaviButton {
        id: defaultsButton
        icon.source: FiberStyle.images.iconSettingsDefault
        property double iconProportion: 0.6
        icon.width: width * iconProportion
        icon.height: width * iconProportion
        icon.color: palette.buttonText

        background: Rectangle {
            color: parent.pressed ? ViaviStyle.colors.selectedColor  : ViaviStyle.colors.contentBackgroundColor
        }

        display: AbstractButton.TextUnderIcon
        text: menuOtdr.generalPage.configSetDefault.name.text
        palette.buttonText: pressed ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor

        Layout.fillWidth: true
        Layout.preferredHeight: width
    }

    popupContentItem: ViaviDialog {
        id: defaultsDialog
        visible: false
        width: parent.width
        height: parent.height
        text: menuOtdr.generalPage.configSetDefaultConfirmation.name.text
        button1Text: menuOtdr.generalPage.configSetDefaultAccept.name.text
        button2Text: menuOtdr.generalPage.configSetDefaultReject.name.text

        onButton1Action: {
            menuOtdr.generalPage.configSetDefaultConfirmation.validateValue()
            close()
        }

        onButton2Action: {
            close()
        }

        Connections {
            target: defaultsButton
            function onClicked() {
                visible = true
            }
        }
    }

}

