import QtQuick 2.3
import QtQuick.Controls 2.1
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0

import libsetupmenu 1.0

ColumnLayout {
    
    GridLayout{
        columns: 2
        rows: 1

        Layout.fillWidth: true
        ViaviMenuLineInputText {
            Layout.fillWidth: true
            textWidth: ViaviStyle.layout.menuTitleWidthSmall
            mainContentFillWidth: true
	    
            text: menuOtdr.linkPage.techId.name.text
            textData.text: menuOtdr.linkPage.techId.value

            onTextClicked:{
                menuOtdr.linkPage.techId.validateValue()
            }
        }

        ViaviMenuLineInputText {
            Layout.fillWidth: true
            textWidth: ViaviStyle.layout.menuTitleWidthSmall
            mainContentFillWidth: true
	    
            text: menuOtdr.linkPage.jobId.name.text
            textData.text: menuOtdr.linkPage.jobId.value
            
            onTextClicked:{
                menuOtdr.linkPage.jobId.validateValue()
            }
        }

    }
    
    MenuSeparator { Layout.fillWidth: true }

    GridLayout{
        columns: 2
        rows: 1
        Layout.fillWidth: true
        
        ViaviMenuLineInputText {
            textWidth: ViaviStyle.layout.menuTitleWidthSmall
            mainContentFillWidth: true
            Layout.fillWidth: true

            text: menuOtdr.linkPage.locationA.name.text
            textData.text: menuOtdr.linkPage.locationA.value
            onTextClicked:{
                menuOtdr.linkPage.locationA.validateValue()
            }
        }

        ViaviMenuLineInputText {
            textWidth: ViaviStyle.layout.menuTitleWidthSmall
            mainContentFillWidth: true
            Layout.fillWidth: true

            text: menuOtdr.linkPage.locationB.name.text
            textData.text: menuOtdr.linkPage.locationB.value
            onTextClicked:{
                menuOtdr.linkPage.locationB.validateValue()
            }
        }
    }

    ViaviMenuLineMultiOption{
        textWidth: ViaviStyle.layout.menuTitleWidthSmall
	Layout.fillWidth: true
		
        text: menuOtdr.linkPage.direction.name.text
        model: menuOtdr.linkPage.direction.multiOptionModel        

        onSgnOptionClicked: {
            menuOtdr.linkPage.direction.validateOption(index)
        }
    }

    ViaviMenuLineSwitch_YesNo {
        id: extremitiesDifferent
        
        textWidth: ViaviStyle.layout.menuTitleWidthSmall
        
        text: menuOtdr.linkPage.differentExtremities.name.text
        checked: menuOtdr.linkPage.differentExtremities.switch

        onSgnSwitch: {
            menuOtdr.linkPage.differentExtremities.validateSwitch(value)
        }
    }

    MenuSeparator { Layout.fillWidth: true }

    RowLayout {
        id: directionGrid
	
        spacing: ViaviStyle.layout.mediumMargin
        Layout.fillWidth: true
        height: ViaviStyle.layout.menuLineHeight

        visible: extremitiesDifferent.checked
        
        Item{
            implicitWidth: ViaviStyle.layout.menuTitleWidthSmall
            Layout.fillWidth: false
            Layout.fillHeight: true
        }

        Item{
            Layout.fillWidth: true
            Layout.fillHeight: true

            implicitWidth: ViaviStyle.layout.menuTitleWidthSmall

            Label {
                anchors.fill: parent

                text: menuOtdr.linkPage.directionLabelA.value
                font: ViaviStyle.layout.activeBoldTextFont
                color: ViaviStyle.colors.activeColor         
                horizontalAlignment : Text.AlignHCenter
                verticalAlignment : Text.AlignVCenter       
            }
        }

        Item{
            Layout.fillWidth: true
            Layout.fillHeight: true

            implicitWidth: ViaviStyle.layout.menuTitleWidthSmall

            Label {
                anchors.fill: parent

                text: menuOtdr.linkPage.directionLabelB.value
                font: ViaviStyle.layout.activeBoldTextFont
                color: ViaviStyle.colors.activeColor
                horizontalAlignment : Text.AlignHCenter
                verticalAlignment : Text.AlignVCenter   
            }
        }        
    }

    ColumnLayout{

        Layout.fillWidth: true

        ViaviMenuLineInputTextText { 
            Layout.fillWidth: true
            mainContentFillWidth: true
            tailContentFillWidth: true
            textWidth: ViaviStyle.layout.menuTitleWidthSmall

            text:  menuOtdr.linkPage.cableId.name.text
            textData.text: menuOtdr.linkPage.cableId.value
            
            visible: menuOtdr.linkPage.cableId.available
            enabled: menuOtdr.linkPage.cableId.enabled
            onTextClicked:{
                menuOtdr.linkPage.cableId.validateValue()
            }

            secondTextData.visible: menuOtdr.linkPage.cableId2.available
            secondTextData.text: menuOtdr.linkPage.cableId2.value
            onSecondTextClicked:{
                menuOtdr.linkPage.cableId2.validateValue()
            }
        }

        ViaviMenuLineInputTextText {
            Layout.fillWidth: true
            mainContentFillWidth: true
            tailContentFillWidth: true
            textWidth: ViaviStyle.layout.menuTitleWidthSmall

            text: menuOtdr.linkPage.fiberId.name.text
            textData.text: menuOtdr.linkPage.fiberId.value
            visible: menuOtdr.linkPage.fiberId.available
            enabled: menuOtdr.linkPage.fiberId.enabled
            onTextClicked:{
                menuOtdr.linkPage.fiberId.validateValue()
            } 

            secondTextData.visible: menuOtdr.linkPage.fiberId2.available
            secondTextData.text: menuOtdr.linkPage.fiberId2.value
            onSecondTextClicked:{
                menuOtdr.linkPage.fiberId2.validateValue()
            }
        }

        ViaviMenuLineInputTextText {
            Layout.fillWidth: true
            mainContentFillWidth: true
            tailContentFillWidth: true
            textWidth: ViaviStyle.layout.menuTitleWidthSmall

            text: menuOtdr.linkPage.fiberNumber.name.text
            textData.text: menuOtdr.linkPage.fiberNumber.value
            visible: menuOtdr.linkPage.fiberNumber.available
            enabled: menuOtdr.linkPage.fiberNumber.enabled
            onTextClicked:{
                menuOtdr.linkPage.fiberNumber.validateValue()
            }  

            secondTextData.visible: menuOtdr.linkPage.fiberNumber2.available
            secondTextData.text: menuOtdr.linkPage.fiberNumber2.value
            onSecondTextClicked:{
                menuOtdr.linkPage.fiberNumber2.validateValue()
            } 
        }

        ViaviMenuLineControl{
            textWidth: ViaviStyle.layout.menuTitleWidthSmall
            Layout.fillWidth: true
            mainContentFillWidth: true

            text: menuOtdr.linkPage.changeFiberNumber.name.text

            visible: menuOtdr.linkPage.changeFiberNumber.available
            
            mainContentItem: RowLayout{
                Layout.fillWidth: true
                height: ViaviStyle.layout.setupMenuLineHeight
                
                ViaviComboBox{
                    Layout.fillWidth: false
                    implicitHeight: ViaviStyle.layout.setupMenuLineHeight
                    implicitWidth: ViaviStyle.layout.menuTextFieldWidth

                    model: menuOtdr.linkPage.changeFiberNumber.multiOptionModel
                    currentIndex: menuOtdr.linkPage.changeFiberNumber.selectedIndex
                    
                    onCurrentIndexChanged: {
                        if (menuOtdr.linkPage.changeFiberNumber.selectedIndex !== currentIndex){
                            menuOtdr.linkPage.changeFiberNumber.validateOption(currentIndex)
                        }
                    }
                }

                Item{
                    implicitHeight: ViaviStyle.layout.setupMenuLineHeight
                    implicitWidth: ViaviStyle.layout.menuTextFieldWidth
                    Layout.fillWidth: true

                    ViaviInputText{
                        anchors.fill: parent

                        visible: menuOtdr.linkPage.changeFiberNumberCustom.available
                        text: menuOtdr.linkPage.changeFiberNumberCustom.value

                        onClicked: {
                           menuOtdr.linkPage.changeFiberNumberCustom.validateValue();
                        }
                    }   
                }
                
                Item{
                    implicitHeight: ViaviStyle.layout.setupMenuLineHeight
                    implicitWidth: ViaviStyle.layout.menuTextFieldWidth
                    Layout.fillWidth: false

                    ViaviComboBox{
                        anchors.fill: parent

                        visible: menuOtdr.linkPage.changeFiberNumber2.available
                        model: menuOtdr.linkPage.changeFiberNumber2.multiOptionModel
                        currentIndex: menuOtdr.linkPage.changeFiberNumber2.selectedIndex
  
                        onCurrentIndexChanged: {
                            if (menuOtdr.linkPage.changeFiberNumber2.selectedIndex !== currentIndex){
                                menuOtdr.linkPage.changeFiberNumber2.validateOption(currentIndex)
                            }
                        }
                    }
                }

                Item{
                    implicitHeight: ViaviStyle.layout.setupMenuLineHeight
                    implicitWidth: ViaviStyle.layout.menuTextFieldWidth
                    Layout.fillWidth: true

                    ViaviInputText{
                        anchors.fill: parent

                        visible: menuOtdr.linkPage.changeFiberNumber2Custom.available
                        text: menuOtdr.linkPage.changeFiberNumber2Custom.value

                        onClicked: {
                           menuOtdr.linkPage.changeFiberNumber2Custom.validateValue();
                        }
                    }  
                }
            }
        }
    }
}

