import QtQuick 2.3
import QtQuick.Controls 2.1
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0

import libsetupmenu 1.0

ColumnLayout {

    GridLayout{
        columns: 2
        columnSpacing: ViaviStyle.layout.largeMargin

        ViaviMenuLineComboBox {
            id: distanceUnit
            Layout.fillWidth: true
            mainContentFillWidth: true
            textWidth: ViaviStyle.layout.menuTitleWidthSmall

            text: menuOtdr.displayPage.distanceUnit.name.text
            visible: comboBoxData.visible

            comboBoxData.model: menuOtdr.displayPage.distanceUnit.multiOptionModel 
            comboBoxData.enabled: menuOtdr.displayPage.distanceUnit.enabled
            comboBoxData.visible: menuOtdr.displayPage.distanceUnit.available
            comboBoxData.currentIndex: menuOtdr.displayPage.distanceUnit.selectedIndex

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.displayPage.distanceUnit.validateOption(comboBoxData.currentIndex)
            }
            Connections {
                target: menuOtdr.displayPage.distanceUnit
                function onSelectedIndexChanged() {
                    distanceUnit.comboBoxData.currentIndex = menuOtdr.displayPage.distanceUnit.selectedIndex;
                }
            }
        }

        Item{
            Layout.fillWidth: true
            implicitWidth: distanceUnit.implicitWidth
            width: distanceUnit.width
            height: distanceUnit.height
            
            ViaviMenuLineSwitch_YesNo {
                text: menuOtdr.displayPage.showCursors.name.text

                anchors.top: parent.top
                anchors.bottom: parent.bottom

                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                checked: menuOtdr.displayPage.showCursors.switch
                enabled: menuOtdr.displayPage.showCursors.enabled
                visible: menuOtdr.displayPage.showCursors.available

                onSgnSwitch: {
                    menuOtdr.displayPage.showCursors.validateSwitch(value)
                }
            }
        }

        Item{
            Layout.fillWidth: true
            implicitWidth: sectionAttenuation.implicitWidth
            width: sectionAttenuation.width
            height: sectionAttenuation.height

            ViaviMenuLineSwitch_YesNo {
                
                anchors.top: parent.top
                anchors.bottom: parent.bottom

                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.displayPage.sectionLength.name.text
                checked: menuOtdr.displayPage.sectionLength.switch
                enabled: menuOtdr.displayPage.sectionLength.enabled
                visible: menuOtdr.displayPage.sectionLength.available

                onSgnSwitch: {
                    menuOtdr.displayPage.sectionLength.validateSwitch(value)
                }
            }
        }

        ViaviMenuLineComboBox {
            id: sectionAttenuation

            Layout.fillWidth: true
            mainContentFillWidth: true
            textWidth: ViaviStyle.layout.menuTitleWidthSmall

            text: menuOtdr.displayPage.sectionAttenuation.name.text
            visible: comboBoxData.visible

            comboBoxData.model: menuOtdr.displayPage.sectionAttenuation.multiOptionModel 
            comboBoxData.enabled: menuOtdr.displayPage.sectionAttenuation.enabled
            comboBoxData.visible: menuOtdr.displayPage.sectionAttenuation.available
            comboBoxData.currentIndex: menuOtdr.displayPage.sectionAttenuation.selectedIndex

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.displayPage.sectionAttenuation.validateOption(comboBoxData.currentIndex)
            }
            Connections {
                target: menuOtdr.displayPage.sectionAttenuation
                function onSelectedIndexChanged() {
                    sectionAttenuation.comboBoxData.currentIndex = menuOtdr.displayPage.sectionAttenuation.selectedIndex;
                }
            }
        }

    }

    MenuSeparator { Layout.fillWidth: true }
    
    ViaviMenuLineMultiOption{
        textWidth: ViaviStyle.layout.menuTitleWidthSmall

        text: menuOtdr.displayPage.resultsOnTrace.name.text
        model: menuOtdr.displayPage.resultsOnTrace.multiOptionModel
        enabled: menuOtdr.displayPage.resultsOnTrace.enabled
        visible: menuOtdr.displayPage.resultsOnTrace.available

        Layout.fillWidth: true

        onSgnOptionClicked: {
            menuOtdr.displayPage.resultsOnTrace.validateOption(index)
        }
    }

    ViaviMenuLineSwitch_YesNo {
        textWidth: ViaviStyle.layout.menuTitleWidthSmall

        text: menuOtdr.displayPage.eventNumber.name.text
        checked: true
        enabled: false
        visible: menuOtdr.displayPage.eventNumber.available

        onSgnSwitch: {
            //menuOtdr.displayPage.eventNumber.validateSwitch(value)
        }
    }
    ViaviMenuLineSwitch_YesNo {
        textWidth: ViaviStyle.layout.menuTitleWidthSmall

        text: menuOtdr.displayPage.slope.name.text
        checked: true
        enabled: false
        visible: menuOtdr.displayPage.slope.available

        onSgnSwitch: {
            //menuOtdr.displayPage.slope.validateSwitch(value)
        }
    }
    ViaviMenuLineSwitch_YesNo {
        textWidth: ViaviStyle.layout.menuTitleWidthSmall

        text: menuOtdr.displayPage.distance.name.text
        checked: true
        enabled: false
        visible: menuOtdr.displayPage.distance.available

        onSgnSwitch: {
            //menuOtdr.displayPage.distance.validateSwitch(value)
        }
    }
    ViaviMenuLineSwitch_YesNo {
        textWidth: ViaviStyle.layout.menuTitleWidthSmall

        text: menuOtdr.displayPage.loss.name.text
        checked: true
        enabled: false
        visible: menuOtdr.displayPage.loss.available

        onSgnSwitch: {
            //menuOtdr.displayPage.loss.validateSwitch(value)
        }
    }
    ViaviMenuLineSwitch_YesNo {
        textWidth: ViaviStyle.layout.menuTitleWidthSmall

        text: menuOtdr.displayPage.reflectance.name.text
        checked: true
        enabled: false
        visible: menuOtdr.displayPage.reflectance.available

        onSgnSwitch: {
            //menuOtdr.displayPage.reflectance.validateSwitch(value)
        }
    }

}

