import QtQuick 2.3
import libfo 1.0

import com.viavi.style 1.0
import com.viavi.fiberutilui.components 1.0
import com.viavi.fiberutilui.Util_Ui_Qt 1.0

Rectangle {
    id: schematicViewItem
    visible: true
    height: 150
    width: 700
   
    clip: true
    
    color: ViaviStyle.colors.lightGray1
    
    // Signals
    signal selectValueChanged( int index );
    
    // Data to configure on parent
    property string textUnit: "N/A"
    property int groupIndexDisplay: 0
    property alias groupModel: listContainer.model
    
    onGroupIndexDisplayChanged: {
         listContainer.positionViewAtIndex(groupIndexDisplay , ListView.Center);
         sliderContainer.value = parseInt(listContainer.visibleArea.xPosition * 100, 10);
         sliderContainer.ratio = parseInt(listContainer.visibleArea.widthRatio * 100 , 10);
    }

    ListView {
        id: listContainer
        orientation: ListView.Horizontal

        boundsBehavior: Flickable.StopAtBounds
        
        onContentXChanged: {
            sliderContainer.value = parseInt(listContainer.visibleArea.xPosition * 100, 10);
            sliderContainer.ratio = parseInt(listContainer.visibleArea.widthRatio * 100 , 10);
        }
        
        onModelChanged: {
        	listContainer.positionViewAtIndex(schematicViewItem.groupIndexDisplay , ListView.Center);
         	sliderContainer.value = parseInt(listContainer.visibleArea.xPosition * 100, 10);
         	sliderContainer.ratio = parseInt(listContainer.visibleArea.widthRatio * 100 , 10);
        }
        
        height: 100

        anchors.top: parent.top
        anchors.topMargin: 10

        anchors.left: parent.left
        anchors.leftMargin: 10
        
        anchors.right: parent.right
        anchors.rightMargin: 10

        delegate: Schematic_View_Group_Description_Item {}
    }
    
    Rectangle {
      id:txtUnits
      
      width: 80
      height: 20
      
      anchors.top: listContainer.bottom
      anchors.topMargin: 10
      
      anchors.right: parent.right
      anchors.rightMargin: 10
      
      color: "transparent"
      
      Text {
         anchors.centerIn: parent
         text: schematicViewItem.textUnit
         color: ViaviStyle.colors.darkGray
         font.pixelSize: 15
      }
    }
    
    ViaviSlider {
      id: sliderContainer
      
      width: parent.width - txtUnits.width - 30
      height: 3
      
      orientation: Qt.Horizontal
      visible: listContainer.visibleArea.widthRatio < 1
      
      enabled: false
      
      value: parseInt(listContainer.visibleArea.xPosition * 100, 10)
      ratio: parseInt(listContainer.visibleArea.widthRatio * 100 , 10)
      
      anchors.verticalCenter: txtUnits.verticalCenter
  
      anchors.left: parent.left
      anchors.leftMargin: 10
    }
}


