import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0

RowLayout {
    id: rootId

    spacing: ViaviStyle.layout.isSmallScreen ?
                 ViaviStyle.layout.veryLargeMargin * 2 : ViaviStyle.layout.veryLargeMargin

    CheckTextButton{
        Layout.fillHeight: true

        enabled: status_res_otdrCableCoEnabled.value ? cable_res_viewTestEnabled.value : true

        checked: !status_res_traceEnabled.value
                 && !status_res_eventsTableEnabled.value
                 && !status_res_otdrCableCoEnabled.value

        text: schematic_res_viewLabel.value

        mouseArea.onClicked: {
            status_act_switchToSLM.invoke()
        }
    }

    CheckTextButton {
        id: traceTabButton
        Layout.fillHeight: true

        enabled: status_res_otdrCableCoEnabled.value ? cable_res_viewTestEnabled.value : true
        checked: status_res_traceEnabled.value

        text: trace_res_viewLabel.value

        mouseArea.onClicked: {
            status_act_switchToTrace.invoke()
        }
    }

    CheckTextButton{
        Layout.fillHeight: true

        checked: status_res_eventsTableEnabled.value
        enabled: status_res_resultsTableAvailable.value

        text: events_res_viewLabel.value

        mouseArea.onClicked: {
            status_act_switchToTable.invoke()
        }
    }

    CheckTextButton{
        Layout.fillHeight: true

        checked: status_res_otdrCableCoEnabled.value
        enabled: cable_res_viewButtonEnabled.value && !status_res_otdrCableCoEnabled.value

        text: cable_res_viewButtonLabel.value

        mouseArea.onClicked: {
            status_act_switchToCable.invoke()
        }

        visible: cable_res_viewButtonEnabled.value
    }

    Item {
        id: spacer
        Layout.fillWidth: true
    }

    ThreeStateButtonOption {
        id: threeStateButton

        visible: !status_res_otdrCableCoEnabled.value
        hasMiddleState: traceTabButton.checked

        Layout.fillHeight: true

        leftText: schematic_res_miniSLMLabel.value
        rightText: trace_res_miniTraceLabel.value

        button.onLeftStateActive: status_cfg_topPanelState.value = status_cfg_topPanelState.enums.ecCustomPanel

        button.onMiddleStateActive: status_cfg_topPanelState.value = status_cfg_topPanelState.enums.ecNoPanel

        button.onRightStateActive: status_cfg_topPanelState.value = status_cfg_topPanelState.enums.ecSummaryPanel

	    Connections{
	        target: status_cfg_topPanelState
	        function onValueChanged() {
                switch(status_cfg_topPanelState.value){
                case status_cfg_topPanelState.enums.ecNoPanel:
                    threeStateButton.button.state = threeStateButton.button.middleState
                    break;
	            case status_cfg_topPanelState.enums.ecSummaryPanel:
                    threeStateButton.button.state = threeStateButton.button.rightState
                    break;
	            default:
                    threeStateButton.button.state = threeStateButton.button.leftState
                    break;
	            }
	        }
	    }

        Connections {
            target: bargraph_res_isFiberDataVisible
            function onValueChanged() {
                if (bargraph_res_isFiberDataVisible.value) {
                    threeStateButton.state = threeStateButton.button.leftState
                    threeStateButton.fixedState = true
                }
                else {
                    threeStateButton.fixedState = false
                }
            }
        }
	    
        //set the initial value, the binding will be broken the first time the user changes it from UI
        button.state: {
            switch(status_cfg_topPanelState.value){
            case status_cfg_topPanelState.enums.ecNoPanel:
                return button.middleState
            case status_cfg_topPanelState.enums.ecSummaryPanel:
                return button.rightState
            default:
                return button.leftState
            }
        }
    }
}
