import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0


BasicContainer{
    id: synopticTestRoot

    width: parent.width
    height: parent.height

    Grid{

        columns: 3
        spacing: 5
        anchors.fill: parent

        Item {

            width: ( parent.width - 20) /3
            height: parent.height /3

            BasicContainer {
                id: processStateTitle

                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height / 3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Process State")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }

            ComboBox {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                anchors.right:parent.right

                width: parent.width
                height: parent.height * 2/3

                model: [ " 0 - cFix_Process_Resting",
                    " 1 - cFix_Process_Loop_Measuring",
                    " 2 - cFix_Process_Master_Measuring",
                    " 3 - cFix_Process_Slave_Measuring",
                    " 4 - cFix_Process_Referencing",
                    " 5 - cFix_Process_Identifying",
                    " 6 - cFix_Process_Messaging",
                    " 7 - cFix_Process_Waiting_Fnum",
                    " 8 - cFix_Process_Msg_Identifying",
                    " 9 - cFix_Process_Msg_Wait_Fnum",
                    " 10 - cFix_Process_Wait_Setup1",
                    " 11 - cFix_Process_Wait_Setup2"
                ]
                onCurrentIndexChanged: {
                    synoptic_cfg_processState.value = currentIndex;
                }

                Component.onCompleted: {
                    //avoids binding loop warning
                    currentIndex = synoptic_cfg_processState.value
                }

            }
        }

        Item {

            width: ( parent.width - 20) /3
            height: parent.height /3


            BasicContainer {
                id: measMasterStateTitle

                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height /3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Measuring Master State")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }

            ComboBox {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                anchors.right:parent.right

                width: parent.width
                height: parent.height /3 * 2

                model: [ " 0 - cFix_Meas_Master_Resting",
                    " 1 - cFix_Meas_Master_Tx_Setup",
                    " 2 - cFix_Meas_Master_IL_Meas",
                    " 3 - cFix_Meas_Master_IL_Tx_Results",
                    " 4 - cFix_Meas_Master_Source",
                    " 5 - cFix_Meas_Master_IL_Rx_Results",
                    " 6 - cFix_Meas_Master_ORL_Meas",
                    " 7 - cFix_Meas_Master_ORL_Tx_Results",
                    " 8 - cFix_Meas_Master_Switch",
                    " 9 - cFix_Meas_Master_ORL_Rx_Results",
                    " 10 - cFix_Meas_Master_OTDR_Meas",
                    " 11 - cFix_Meas_Master_OTDR_Wait",
                    " 12 - cFix_Meas_Master_OTDR_Tx_Results",
                    " 13 - cFix_Meas_Master_OTDR_Rx_Results",
                    " 14 - cFix_Meas_Master_Fiber_Length_Meas",
                    " 15 - cFix_Meas_Master_Fiber_Length_Tx_Results"
                ]
                onCurrentIndexChanged: {
                    synoptic_cfg_measMasterState.value = currentIndex;
                }

                Component.onCompleted: {
                    //avoids binding loop warning
                    currentIndex = synoptic_cfg_measMasterState.value
                }
            }
        }

        /*
    typedef enum
       {
       cFix_Meas_Master_Resting = 0,
       cFix_Meas_Master_Tx_Setup,
       cFix_Meas_Master_IL_Meas,
       cFix_Meas_Master_IL_Tx_Results,
       cFix_Meas_Master_Source,
       cFix_Meas_Master_IL_Rx_Results,
       cFix_Meas_Master_ORL_Meas,
       cFix_Meas_Master_ORL_Tx_Results,
       cFix_Meas_Master_Switch,
       cFix_Meas_Master_ORL_Rx_Results,
       cFix_Meas_Master_OTDR_Meas,
       cFix_Meas_Master_OTDR_Wait,
       cFix_Meas_Master_OTDR_Tx_Results,
       cFix_Meas_Master_OTDR_Rx_Results,
       cFix_Meas_Master_Fiber_Length_Meas,
       cFix_Meas_Master_Fiber_Length_Tx_Results,
       cNb_Meas_Master_Graph_State
       } tFix_Meas_Master_Graph_State ;
    */

        Item {

            width: ( parent.width - 20) /3
            height: parent.height /3

            BasicContainer {
                id: measSlaveStateTitle

                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height /3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Measuring Slave State")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }
            ComboBox {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                anchors.right:parent.right

                width: parent.width
                height: parent.height /3 * 2

                model: [ " 0 - cFix_Meas_Slave_Resting",
                    " 1 - cFix_Meas_Slave_Rx_Setup",
                    " 2 - cFix_Meas_Slave_Src",
                    " 3 - cFix_Meas_Slave_IL_Rx_Results",
                    " 4 - cFix_Meas_Slave_IL_Meas",
                    " 5 - cFix_Meas_Slave_IL_Tx_Results",
                    " 6 - cFix_Meas_Slave_Switch",
                    " 7 - cFix_Meas_Slave_ORL_Rx_Results",
                    " 8 - cFix_Meas_Slave_ORL_Meas",
                    " 9 - cFix_Meas_Slave_ORL_Tx_Results",
                    " 10 - cFix_Meas_Slave_OTDR_Waiting",
                    " 11 - cFix_Meas_Slave_OTDR_Meas",
                    " 12 - cFix_Meas_Slave_OTDR_Rx_Results",
                    " 13 - cFix_Meas_Slave_OTDR_Tx_Results",
                    " 14 - cFix_Meas_Slave_Fiber_Length_Waiting",
                    " 15 - cFix_Meas_Slave_Fiber_Length_Rx_Results"
                ]
                onCurrentIndexChanged: {
                    synoptic_cfg_measSlaveState.value = currentIndex;
                }

                Component.onCompleted: {
                    //avoids binding loop warning
                    currentIndex = synoptic_cfg_measSlaveState.value
                }
            }
        }
        /*
    typedef enum
       {
       cFix_Meas_Slave_Resting = 0,
       cFix_Meas_Slave_Rx_Setup,
       cFix_Meas_Slave_Src,
       cFix_Meas_Slave_IL_Rx_Results,
       cFix_Meas_Slave_IL_Meas,
       cFix_Meas_Slave_IL_Tx_Results,
       cFix_Meas_Slave_Switch,
       cFix_Meas_Slave_ORL_Rx_Results,
       cFix_Meas_Slave_ORL_Meas,
       cFix_Meas_Slave_ORL_Tx_Results,
       cFix_Meas_Slave_OTDR_Waiting,
       cFix_Meas_Slave_OTDR_Meas,
       cFix_Meas_Slave_OTDR_Rx_Results,
       cFix_Meas_Slave_OTDR_Tx_Results,
       cFix_Meas_Slave_Fiber_Length_Waiting,
       cFix_Meas_Slave_Fiber_Length_Rx_Results,
       cNb_Meas_Slave_Graph_State
       } tFix_Meas_Slave_Graph_State ;
    */

        Item {

            width: ( parent.width - 20) /3
            height: parent.height /3

            BasicContainer {
                id: referenceStateTitle

                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height /3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Reference State")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }


            ComboBox {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                anchors.right:parent.right

                width: parent.width
                height: parent.height /3 * 2

                model: [ " 0 - cFix_Ref_Resting",
                    " 1 - cFix_Ref_Loopback_Referencing",
                    " 2 - cFix_Ref_Pow_Referencing",
                    " 3 - cFix_Ref_Zero_Referencing",
                    " 4 - cFix_Ref_Tx_Header_As_Master",
                    " 5 - cFix_Ref_Rx_Header_As_Slave",
                    " 6 - cFix_Ref_Measuring_As_Master",
                    " 7 - cFix_Ref_Measuring_As_Slave",
                    " 8 - cFix_Ref_Emitting_As_Master",
                    " 9 - cFix_Ref_Emitting_As_Slave",
                    " 10 - cFix_Ref_Otdr_As_Master",
                    " 11 - cFix_Ref_Otdr_Master_Wait",
                    " 12 - cFix_Ref_Otdr_As_Slave",
                    " 13 - cFix_Ref_Otdr_Slave_Wait"
                ]
                onCurrentIndexChanged: {
                    synoptic_cfg_referenceState.value = currentIndex;
                }

                Component.onCompleted: {
                    //avoids binding loop warning
                    currentIndex = synoptic_cfg_referenceState.value
                }
            }
        }

        Item {

            width: ( parent.width - 20) /3
            height: parent.height /3

            BasicContainer {
                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height /3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Ref OTDR 1st con")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }


            ComboBox {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                anchors.right:parent.right

                width: parent.width
                height: parent.height /3 * 2

                model: [ " 0 - cRef_Otdr_Pass",
                    " 1 - cRef_Otdr_Fail",
                    " 2 - cRef_Otdr_Undefined",
                ]
                onCurrentIndexChanged: {
                    synoptic_cfg_refOTDRFirstConnectorState.value = currentIndex;
                }

                Component.onCompleted: {
                    //avoids binding loop warning
                    currentIndex = synoptic_cfg_refOTDRFirstConnectorState.value
                }

            }
        }

        Item {

            width: ( parent.width - 20) /3
            height: parent.height /3

            BasicContainer {
                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height /3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Ref OTDR 2nd con")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }


            ComboBox {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                anchors.right:parent.right

                width: parent.width
                height: parent.height /3 * 2


                model: [ " 0 - cRef_Otdr_Pass",
                    " 1 - cRef_Otdr_Fail",
                    " 2 - cRef_Otdr_Undefined",
                ]
                onCurrentIndexChanged: {
                    synoptic_cfg_refOTDRMiddleConnectorState.value = currentIndex;
                }

                Component.onCompleted: {
                    //avoids binding loop warning
                    currentIndex = synoptic_cfg_refOTDRMiddleConnectorState.value
                }
            }
        }

        CheckBox{
            width: ( parent.width - 20) /3
            height: parent.height /4

            text: "Timer"

            checked: synoptic_cfg_timerTest.value

            onClicked: {
                synoptic_cfg_timerTest.value = !synoptic_cfg_timerTest.value
            }
        }

        Item {

            width: ( parent.width - 20) /3
            height: parent.height /3


            BasicContainer {
                id: fixDataStateTitle

                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height /3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Fix Data State")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }

            ComboBox {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                anchors.right:parent.right

                width: parent.width
                height: parent.height /3 * 2

//                typedef enum
//                   {
//                   cFixdata_Meas_Resting = 0,
//                   cFixdata_Meas_Connected,
//                   cFixdata_Meas_Sequencing,
//                   cFixdata_Meas_IL_Meas,
//                   cFixdata_Meas_ORL_Meas,
//                   cFixdata_Meas_Source, // Comme cFixdata_Meas_ORL_Meas en tous points sauf qu'on ignore l'ORL
//                   cFixdata_Meas_Exchanging,
//                   cFixdata_Meas_OTDR_Meas,
//                   cFixdata_Meas_OTDR_Wait,
//                   cFixdata_File_Exchanging,
//                   cNb_Fixdata_Meas_Graph_State
//                   } tFixdata_Meas_Graph_State ;

                model: [ " 0 - cFixdata_Meas_Resting",
                    " 1 - cFixdata_Meas_Connected",
                    " 2 - cFixdata_Meas_Sequencing",
                    " 3 - cFixdata_Meas_IL_Meas",
                    " 4 - cFixdata_Meas_ORL_Meas",
                    " 5 - cFixdata_Meas_Source",
                    " 6 - cFixdata_Meas_Exchanging",
                    " 7 - cFixdata_Meas_OTDR_Meas",
                    " 8 - cFixdata_Meas_OTDR_Wait",
                    " 9 - cFixdata_File_Exchanging"
                ]
                onCurrentIndexChanged: {
                    synoptic_cfg_fixDataState.value = currentIndex;
                }

                Component.onCompleted: {
                    //avoids binding loop warning
                    currentIndex = synoptic_cfg_fixDataState.value
                }
            }
        }
        Item {
            id: fixDeviceType
            width: ( parent.width - 20) /3
            height: parent.height /3
            BasicContainer {
                id: fixDeviceTypeTitle
                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                height: parent.height /3
                width: parent.width

                Text {
                    anchors.centerIn: parent
                    text: qsTr("Fix Device Type")
                    font: ViaviStyle.layout.activeBoldTextFont
                }
            }
            property var deviceTypeList: [ '0 - SmartOTDR',
                                            '1 - 2000',
                                            '2 - 4000',
                                            '3 - 5800',
                                            '5 - ONA-800',
                                            '4 - ONA-1000'
                                            ]
            ComboBox {
                id: localDeviceType
                anchors.bottom: parent.bottom
                anchors.left: parent.left

                width: parent.width / 2
                height: parent.height /3 * 2
                model: fixDeviceType.deviceTypeList

                onCurrentIndexChanged: {
                    synoptic_cfg_localDeviceType.value = currentIndex
                    console.error('synoptic_cfg_localDeviceType.value: ' + synoptic_cfg_localDeviceType.value)
                }
            }
            ComboBox {
                id: remoteDeviceType
                anchors.bottom: parent.bottom
                anchors.left: localDeviceType.right
                anchors.right:parent.right

                width: parent.width / 2
                height: parent.height /3 * 2
                model: fixDeviceType.deviceTypeList

                onCurrentIndexChanged: {
                    synoptic_cfg_remoteDeviceType.value = currentIndex
                    console.error('synoptic_cfg_remoteDeviceType.value:' + synoptic_cfg_remoteDeviceType.value)
                }
            }
        }
    }
}
