import QtQuick 2.3
import QtQuick.Layouts 1.1
import elf_plugin 1.0

import com.viavi.style 1.0
import com.viavi.fiberutilui 1.0

Item {
    id:root

    property Item localDevice: null
    property Item remoteDevice: null
    property alias leftConnectorSource: leftConnector.source
    property alias rightConnectorSource: rightConnector.source
    property alias middleFiberSource: middleFiber.source
    property alias leftLineSource: leftLine.source
    property alias rightLineSource: rightLine.source
    property alias quarterFiberLeftSource: quarterFiberLeft.source
    property alias quarterFiberRightSource: quarterFiberRight.source
    property alias loopback1StFiber: loopback1StFiberNumber.text
    property alias loopback2NdFiber: loopback2NdFiberNumber.text
    
    signal leftLineClick()
    signal rightLineClick()

    function getStateName() {
        switch(synoptic_res_linkState.value){
        case synoptic_res_linkState.enums.elsConnected:
            return connectedState
        case synoptic_res_linkState.enums.elsLoopback:
            return loopbackState
        case synoptic_res_linkState.enums.elsLoopback_AB:
            return loopbackABState
        case synoptic_res_linkState.enums.elsLoopback_BA:
            return loopbackBAState
        case synoptic_res_linkState.enums.elsTerminator:
            return terminatorState
        case synoptic_res_linkState.enums.elsMPO_Terminator:
            return terminatorMPOState
        case synoptic_res_linkState.enums.elsMPOwCap_Terminator:
            return terminatorMPOWithCapState
        case synoptic_res_linkState.enums.elsJumper:
            return jumperState
        case synoptic_res_linkState.enums.elsTCV_ReferenceGrade:
            return testCableVerifyRefGradeState
        case synoptic_res_linkState.enums.elsTCV_ReferenceGradeLoopback:
            return testCableVerifyRefGradeLoopbackState
        }

        return noLinkState
    }

    readonly property string connectedState: "connectedState"
    readonly property string loopbackState: "loopbackState"
    readonly property string loopbackABState: "loopbackABState"
    readonly property string loopbackBAState: "loopbackBAState"
    readonly property string terminatorState: "terminatorState"
    readonly property string terminatorMPOState: "terminatorMPOState"
    readonly property string terminatorMPOWithCapState: "terminatorMPOWithCapState"
    readonly property string jumperState: "jumperState"
    readonly property string noLinkState: "noLinkState"
    readonly property string testCableVerifyRefGradeState: "testCableVerifyRefGradeState"
    readonly property string testCableVerifyRefGradeLoopbackState: "testCableVerifyRefGradeLoopbackState"


    state: getStateName()

    function getConnectorImage(elfEnum){
        switch(elfEnum.value){
        case elfEnum.enums.ecsOTDRPass:
            return FiberStyle.images.fixRefIconPass
        case elfEnum.enums.ecsOTDRFail:
            return FiberStyle.images.fixRefIconFail
        }

        return ""
    }

    height: leftConnector.height

    Image{
        id: leftConnector

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.left
        
        MouseArea {
			anchors.fill: parent
			onClicked: { leftLineClick() }
		}
    }

    Image{
        id: rightConnector

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.right
        
        MouseArea {
			anchors.fill: parent
			onClicked: { rightLineClick() }
		}
    }

    Text {
        id: loopback1StFiberNumber

        anchors.right: quarterFiberLeft.left
        anchors.rightMargin: ViaviStyle.layout.mediumMargin
        anchors.bottom: quarterFiberLeft.top
        // using negative margins since the icon has a lot of blank space on top
        // and there is no other space available for this label
        anchors.bottomMargin: -quarterFiberLeft.height * 0.4

        font: ViaviStyle.layout.activeTextFont
        color: ViaviStyle.colors.mainInfoColor
        z: quarterFiberLeft.z + 1
    }

    Text {
        id: loopback2NdFiberNumber

        anchors.right: quarterFiberLeft.left
        anchors.rightMargin: ViaviStyle.layout.mediumMargin
        anchors.top: quarterFiberLeft.bottom
        anchors.topMargin: ViaviStyle.layout.smallMargin

        font: ViaviStyle.layout.activeTextFont
        color: ViaviStyle.colors.mainInfoColor
        z: quarterFiberLeft.z + 1
    }

    Image{
        id: middleFiber

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.top: leftConnector.top

        x: rightConnector.source.toString().length === 0
           ? parent.width - width
           : parent.width / 2 - width / 2
    }

    Image{
        id: leftLine

        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.top: leftConnector.top
        anchors.left: leftConnector.right
        anchors.right: middleFiber.left
    }

    Image{
        id: quarterFiberLeft

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.top: leftLine.top
        anchors.horizontalCenter: leftLine.horizontalCenter
    }

    Image{
        id: rightLine

        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.top: middleFiber.top
        anchors.left: middleFiber.right
        anchors.right: rightConnector.left
    }

    Image{
        id: quarterFiberRight

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.top: rightLine.top
        anchors.horizontalCenter: rightLine.horizontalCenter
    }

    Image{
        id: firstConnectorState

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.top: leftConnector.top
        anchors.horizontalCenter: leftConnector.horizontalCenter

        source: getConnectorImage(synoptic_res_firstConnectionState)
    }

    Image{
        id: middleConnectorState

        fillMode: Image.PreserveAspectFit
        width: sourceSize.width * ViaviStyle.layout.fixImageScale
        height: sourceSize.height * ViaviStyle.layout.fixImageScale

        anchors.top: middleFiber.top
        anchors.horizontalCenter: middleFiber.horizontalCenter

        source: getConnectorImage(synoptic_res_middleConnectionState)
    }


    states: [
        State {
            name: connectedState
            PropertyChanges { target: root; visible: true
                width: remoteDevice.connectorX - localDevice.connectorX
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnectorLaunch
                rightConnectorSource: FiberStyle.images.fixLinkRightConnectorLaunch
                middleFiberSource: FiberStyle.images.fixLinkFiberMiddle
                leftLineSource: FiberStyle.images.fixLinkFiberLine
                rightLineSource: FiberStyle.images.fixLinkFiberLine
                quarterFiberLeftSource: ""
                quarterFiberRightSource: ""
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        },
        State {
            name: loopbackState
            PropertyChanges { target: root; visible: true
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnector
                rightConnectorSource: FiberStyle.images.fixLinkRightConnector
                middleFiberSource: FiberStyle.images.fixLinkFiberLineLaunch
                leftLineSource: FiberStyle.images.fixLinkFiberLineLaunch
                rightLineSource: FiberStyle.images.fixLinkFiberLineLaunch
                width: localDevice.width / 3;
                x: localDevice.connectorX - width / 2;
                y: localDevice.connectorY - height;
                quarterFiberLeftSource: ""
                quarterFiberRightSource: ""
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        },
        State {
            name: loopbackABState
            PropertyChanges { target: root;     visible: true
                width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnectorLoopAB
                rightConnectorSource: ""
                middleFiberSource: FiberStyle.images.fixLinkFiberMiddleLoopABBA
                leftLineSource: FiberStyle.images.fixLinkFiberLineLoopABBA
                rightLineSource: ""
                quarterFiberLeftSource: FiberStyle.images.fixLinkFiberQuarterFiberLoopABBA
                quarterFiberRightSource: ""
                loopback1StFiber: synoptic_res_loopback1StFiberNumber.value
                loopback2NdFiber: synoptic_res_loopback2NdFiberNumber.value
            }
        },
        State {
            name: loopbackBAState
            PropertyChanges { target: root; visible: true
                width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnectorLoopBA
                rightConnectorSource: ""
                middleFiberSource: FiberStyle.images.fixLinkFiberMiddleLoopABBA
                leftLineSource: FiberStyle.images.fixLinkFiberLineLoopABBA
                rightLineSource: ""
                quarterFiberLeftSource: FiberStyle.images.fixLinkFiberQuarterFiberLoopABBA
                quarterFiberRightSource: ""
                loopback1StFiber: synoptic_res_loopback1StFiberNumber.value
                loopback2NdFiber: synoptic_res_loopback2NdFiberNumber.value
            }
        },
        State {
            name: terminatorState
            PropertyChanges { target: root; visible: true
                width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnectorSimpleLaunch
                rightConnectorSource: ""
                middleFiberSource: FiberStyle.images.fixLinkFiberMiddleTerminator
                leftLineSource: FiberStyle.images.fixLinkFiberLineLaunch
                rightLineSource: ""
                quarterFiberLeftSource: FiberStyle.images.fixLinkFiberMiddleLaunch
                quarterFiberRightSource: ""
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        },
        State {
            name: jumperState
            PropertyChanges { target: root; visible: true
                width: remoteDevice.connectorX - localDevice.connectorX
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnectorSimpleLaunch
                rightConnectorSource: FiberStyle.images.fixLinkRightConnectorSimpleLaunch
                middleFiberSource: FiberStyle.images.fixLinkFiberMiddleJumper
                leftLineSource: FiberStyle.images.fixLinkFiberLineLaunch
                rightLineSource: FiberStyle.images.fixLinkFiberLineLaunch
                quarterFiberLeftSource: FiberStyle.images.fixLinkFiberMiddleLaunch
                quarterFiberRightSource: FiberStyle.images.fixLinkFiberMiddleLaunch
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        },
        State {
            name: terminatorMPOState
            PropertyChanges { target: root; visible: true
                width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnectorSimpleLaunch
                rightConnectorSource: ""
                middleFiberSource: FiberStyle.images.fixLinkFiberMiddleTerminatorMPO
                leftLineSource: FiberStyle.images.fixLinkFiberLineLaunch
                rightLineSource: ""
                quarterFiberLeftSource: FiberStyle.images.fixLinkFiberMiddleLaunch
                quarterFiberRightSource: ""
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        },
        State {
            name: terminatorMPOWithCapState
            PropertyChanges { target: root; visible: true
                width: 2 * (root.parent.width / 2 - localDevice.connectorX)
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: FiberStyle.images.fixLinkLeftConnectorSimpleLaunch
                rightConnectorSource: ""
                middleFiberSource: FiberStyle.images.fixLinkFiberMiddleTerminatorMPOWithCap
                leftLineSource: FiberStyle.images.fixLinkFiberLineLaunch
                rightLineSource: ""
                quarterFiberLeftSource: FiberStyle.images.fixLinkFiberMiddleLaunch
                quarterFiberRightSource: ""
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        },
        State {
            name: testCableVerifyRefGradeLoopbackState

            PropertyChanges { target: root; visible: true
                width: localDevice.width / 3;
                x: localDevice.connectorX - width / 2;
                y: localDevice.connectorY - height;
                leftConnectorSource: ViaviStyle.images.fixLinkLeftConnector
                rightConnectorSource: ViaviStyle.images.fixLinkRightConnectorReferenceGradeJumper
                middleFiberSource: ViaviStyle.images.fixLinkFiberMiddleJumper
                leftLineSource: ""
                rightLineSource: ""
                quarterFiberLeftSource: ""
                quarterFiberRightSource: ""
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        }, 
        State {
            name: testCableVerifyRefGradeState

            PropertyChanges { target: root; visible: true
                width: remoteDevice.connectorX - localDevice.connectorX
                x: localDevice.connectorX;
                y: localDevice.connectorY - height;
                leftConnectorSource: ViaviStyle.images.fixLinkLeftConnectorLaunch
                rightConnectorSource: ViaviStyle.images.fixLinkRightConnectorLaunch
                middleFiberSource: ViaviStyle.images.fixLinkFiberMiddleReferenceGradeJumper
                leftLineSource: middleFiberSource
                rightLineSource: middleFiberSource
                quarterFiberLeftSource: ""
                quarterFiberRightSource: ""
                loopback1StFiber: ""
                loopback2NdFiber: ""
            }
        }, 
        State {
            name: noLinkState
            PropertyChanges { target: root; visible: false}
        }
    ]
}
