import QtQuick 2.3
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0
import com.viavi.fiberutilui.components 1.0

BasicContainer{
    id : root
    
    readonly property int alarmStatusFailed: -1
    property real aboutIconScale: 0.8
    
    function getTextColor(alarm, text){
        if(text === ""){
            return ViaviStyle.colors.mainInfoColor
        }else{
            return ViaviStyle.colors.getTextColor(alarm)
        }
    } 
    ColumnLayout{
        id: columnId
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.leftMargin : ViaviStyle.layout.largeMargin
        anchors.rightMargin : ViaviStyle.layout.largeMargin
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin : ViaviStyle.layout.mediumMargin
        anchors.bottomMargin : ViaviStyle.layout.mediumMargin

        property real passCellWidth: ViaviStyle.layout.veryLargeMargin
        property real cellWidth : (width - passCellWidth) / 4

        TableHeaderRow{
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_laserLabel.value
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_lossLabel.value
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_orlLabel.value
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                valueText: fibers_res_attenuationLabel.value
            }
            TableHeaderCell{
                width: columnId.passCellWidth
                valueTextHorizontalAllignment: Text.AlignHCenter
                valueTextVerticalAlignment: Text.AlignVCenter
                //valueText: "P/F"
                valueText: fibers_res_passLabel.value
            }
        }

        ListView {
            id: theListView

            Layout.fillHeight : true
            Layout.fillWidth: true

            boundsBehavior: Flickable.OvershootBounds
            clip: true
            model: fibers_res_fibersData.value

            delegate: TableRow {
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: laser
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: loss
                    valueColor: root.getTextColor( alarm_loss, loss )                  
                    
                    MouseArea{
                    anchors.fill: parent
                    enabled: alarm_loss == alarmStatusFailed ? true : false
                    onClicked:{
                        fibers_act_displayLossAlarmInfoMessage.invokeWithStringArg( index )
                        }
                    }

                    ColorImage {
                    height: parent.height * aboutIconScale
                    width: height
                    anchors.top: parent.top
                    anchors.right: parent.right
                    anchors.rightMargin: ViaviStyle.layout.veryLargeMargin
                    source: FiberStyle.images.aboutIcon
                    visible: alarm_loss == alarmStatusFailed ? true : false
                    color: ViaviStyle.colors.activeColor
                    }                              
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: orl
                    valueColor: root.getTextColor( alarm_orl, orl )
                    
                    MouseArea{
                    anchors.fill: parent
                    enabled: alarm_orl == alarmStatusFailed ? true : false
                    onClicked:{
                        fibers_act_displayOrlAlarmInfoMessage.invoke()
                        }
                    }
                                        
                    ColorImage {
                    height: parent.height * aboutIconScale
                    width: height
                    anchors.top: parent.top
                    anchors.right: parent.right
                    anchors.rightMargin: ViaviStyle.layout.veryLargeMargin
                    source: FiberStyle.images.aboutIcon
                    visible: alarm_orl == alarmStatusFailed ? true : false                    
                    color: ViaviStyle.colors.activeColor
                   
                    }
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: attenuation
                }
                Image {
                    anchors.top: parent.top
                    anchors.bottom: parent.bottom
                    width: columnId.passCellWidth

                    fillMode: Image.PreserveAspectFit
                    source: pass
                }
            }
        }
    }
}

