import QtQuick 2.3
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

Item{
    height: ViaviStyle.layout.buttonHeight

    Row{
        id: buttonsRow
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.mediumMargin

        spacing: ViaviStyle.layout.mediumMargin
        
        ImageButton{
        	visible: fcomp_res_isSwitchSelected.value
        	
            source: FiberStyle.images.indicatorLeft
            onClicked:{
                fcomp_act_decreaseMpoReferenceAction.invoke()
            }
        }
        
        Text {
        	visible: fcomp_res_isSwitchSelected.value
            text: "#"+fcomp_res_referenceChannelSelected.value
            font: ViaviStyle.layout.tableTitleFont
            color: ViaviStyle.colors.mainInfoColor
            
            width: 20
            horizontalAlignment: Text.AlignHCenter
            
            anchors.verticalCenter: parent.verticalCenter
        }
        
        ImageButton{
        	visible: fcomp_res_isSwitchSelected.value
        	
            source: FiberStyle.images.indicatorRight
            onClicked:{
                fcomp_act_increaseMpoReferenceAction.invoke()
            }
        }

        ImageButton{
        	visible: true
            source: FiberStyle.images.factoryResetIcon
            onClicked:{
                fcomp_act_factoryReferenceAction.invoke()
            }
        }

        Item{
            visible: testCordVerificationButton.visible
            width: ViaviStyle.layout.buttonHeight / 3
            anchors.top: parent.top
            anchors.bottom: parent.bottom
        }

        ImageButton{
            id: testCordVerificationButton
            visible: !fcomp_res_isSwitchSelected.value
            source: FiberStyle.images.testCordVerificationIcon
            onClicked:{
                fcomp_act_testCordVerificationAction.invoke()
            }
        }

        Item{
            anchors.top: parent.top
            anchors.bottom: parent.bottom
        }
    }
}
