import QtQuick 2.3

import com.viavi.style 1.0

Rectangle {
	id: container
	
    width: 650
    height: 120
                
	visible: false

    readonly property int maxColumnCount: 12
	property int groupe_size: 0
	property int fiber_start_index: 0
	
    color: "#414141"

    GridView {
        id: gridView
        property int rowCount: Math.ceil(groupe_size / maxColumnCount)
        property int columnCount: Math.min(groupe_size, maxColumnCount)

        property int maxWidth: parent.width - 2*ViaviStyle.layout.mediumMargin
        property int maxHeight: parent.height - 2*ViaviStyle.layout.mediumMargin

        cellWidth: Math.min(maxWidth / columnCount, maxHeight / rowCount)
        cellHeight: cellWidth

        anchors.centerIn: parent
        width: Math.min(columnCount * cellWidth, maxWidth)
        height: Math.min(rowCount * cellHeight, maxHeight)

	    anchors.horizontalCenter: parent.horizontalCenter
	    anchors.verticalCenter: parent.verticalCenter
	    
	    clip: true
	    interactive: false
	    
        model: groupe_size
        delegate: Cable_Co_Enterprise_Port {
            fiber_index: fiber_start_index + index
            width: gridView.cellWidth
            height: gridView.cellHeight
        }
	}
}
