<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright VIAVI Solutions 2017. All rights reserved.
// *********************************************************
namespace app\view;

use app\http\SMTContext;

/**
 * Generates an html test page;
 *
 * @author Sylvain Desplat
 */
class SMTRedirectLoginPage implements SMTIPage
{
	const REDIRECT_LOGIN_FILE = "app/view/SMTRedirectLoginLayout.php";
	
	/**
	 * 
	 * @var string
	 */
    private $htmlFile;
    
    /**
     * 
     * @var app\http\SMTContext
     */
    private $context;    
    
    /**
     * Redirect to login page
     * 
     * @param SMTContext $context
     */	
	function __construct( $context)
	{
		$this->htmlFile = self::REDIRECT_LOGIN_FILE;
		$this->context = $context;
	}
		
	/**
	 * Generate the redirection to login page
	 *
     * @return page generation status
	 */
	function generatePage()
	{
        //populate the redirect login layout page
		include $this->htmlFile;
	}
}

?>