<?php
namespace app\util\upload;

require_once('SMTUpload.php');

use app\services\maintenance\SMTUploadStatusDto;
use app\util\SMTLogger;
use app\util\SMTUtil;
use app\util\upload\SMTUploadStatus;
use app\serviceshelper\maintenance\SMTLicence;

// function checkContent()
// {
// 	$licenseHelper = new SMTLicence();
// 	$licenseHelper->setContext( $this->getContext() );
	
// 	if ( !empty( $filename ) )
// 	{
// 		$licenseHelper->processLicense($filename);
// 	}
// 	else
// 	{
// 		throw new SMTIOException(SMTIOException::INVALID_FILE, "empty file");
// 	}
// }

/**
 * Begining of upload script
 * 
 */
//2mn script timeout
set_time_limit(120);

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning == TRUE )
{
	$uploadStatus = upload_file( SMTUtil::SMARTOTU_TEMP_DIR, 'checkLicense', FALSE);

	//always remove license file after upload (can contain malicious code)
	if ( file_exists( SMTUtil::SMARTOTU_TEMP_DIR.$_FILES['datafile']['name']) )
	{
		unlink(SMTUtil::SMARTOTU_TEMP_DIR.$_FILES['datafile']['name']);
	}
	
    if ( $uploadStatus->getUploadErrorStatus() == SMTUploadStatusDto::NO_ERROR )
    {
        SMTLogger::getInstance()->trace( sprintf("Upload of license %s complete...", $uploadStatus->getFileName()), SMTLogger::PINFO);
    }
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
    
    // add error code 401 in case of upload failure
    @header('Cache-Control: no-cache, must-revalidate', true, 401 ); 
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>