#!/usr/bin/env php 
<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2024. All rights reserved.
// *********************************************************
/**
 * WARNING: Executable script to execute async SCPI commands.
 * 
 */

/**
 * include autoloader
 */
require_once 'app/util/SMTLogger.php';
require_once 'lib/restler.php';
require_once 'app/http/SMTContext.php';
require_once 'app/serviceshelper/otdr/SMTMeasurementInstrument.php';

function trace( $message )
{
    error_log( app\util\SMTLogger::formatMessage($message, app\util\SMTLogger::DEBUG) );
} 

function traceException( $message )
{
    error_log( app\util\SMTLogger::formatMessage($message, app\util\SMTLogger::ERROR) );
}

/**
 * Retrieve command line arguments:
 * Command should be:
 * 
 * ./measurementProcess.php -- measureOnDemandClass,operationId >> /logfile/path 2>&1 &
 * 
 * argv[0] -> ./asyncCommandProcess.php
 * argv[1] -> SCPI
 * argv[2] -> sleep before start
 *
 */
$args_string = implode(' ', $argv);
//trace( "Start async SCPI command: $args_string");
list($fake, $sleepBeforeStart) = explode( "@@" ,$args_string );

trace( sprintf("Start async command sleep %d", $sleepBeforeStart) );

    $context = new app\http\SMTContext();
    
    $sleepBeforeStart = intval($sleepBeforeStart);
    
    try 
    {
        app\serviceshelper\otdr\SMTMeasurementInstrument::restartSequencer($context, $sleepBeforeStart);
       
        trace( "execute async restart sequencer command" );
    } 
    catch (Exception $e) 
    {
        traceException( sprintf( "Failure in async restart sequencer command %s: %s", $e->getMessage() ) );
    }



exit(0);
?>