<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright VIAVI Solutions 2019. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otdr;


use app\util\SMTLogger;

/**
 * Trace file type SOR, CSOR,MSOR, DTS, ...).
 *
 * @author Sylvain Desplat
 */
class SMTTraceFileType
{
	/**
	 * OTU sor file
	 * @var string
	 */
	const SOR = 'sor';

	/**
	 * OTU sor file
	 * @var string
	 */
	const CSOR = 'csor';
	
	/**
	 * OTU sor file
	 * @var string
	 */
	const MSOR = 'msor';

	/**
	 * OTU sor file
	 * @var string
	 */
	const DTS = 'dts';
	
	/**
	 * OTU sor file
	 * @var string
	 */
	const DTSS = 'dtss';
	
	
	
	/**
	 * Returns the type of file: SMTTraceFileType
	 * 
	 * @param string $acquisitionTrace
	 * @param string $Error
	 * @return string SMTTraceFileType::SOR,...
	 */
	public static function getFileType($acquisitionTrace, &$Error=FALSE)
	{
		$ext = SMTBaseOtdrTraceFileUtil::OTDR_FILE_SOR_EXTENSION;
		$Error = FALSE;
		
		
		//search if csor, msor or sor exists
		$acquisitionTraceWithoutExt = substr($acquisitionTrace, 0,strrpos($acquisitionTrace,"."));
		
		if ( file_exists($acquisitionTraceWithoutExt.'.'.self::CSOR) )
		{
			$ext = self::CSOR;
		}
		else if ( file_exists($acquisitionTraceWithoutExt.'.'.self::MSOR) )
		{
			$ext = self::MSOR;
		}
		else if ( file_exists($acquisitionTraceWithoutExt.'.'.self::SOR) )
		{
			$ext = self::SOR;
		}
		else if ( file_exists($acquisitionTraceWithoutExt.'.'.self::DTS) )
		{
			$ext = self::DTS;
		}
		else if ( file_exists($acquisitionTraceWithoutExt.'.'.self::DTSS) )
		{
			$ext = self::DTSS;
		}
		else
		{
			SMTLogger::getInstance()->trace("file not found: ".$acquisitionTrace, SMTLogger::ERROR, __FILE__,__METHOD__,__LINE__);
			$Error = TRUE;
		}
		return $ext;
	}
}
?>