<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otdr;

use app\util\SMTInvalidValueException;

use app\util\SMTUtil;

use app\util\SMTDto;

/**
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOtdrFunctionDto extends SMTDto
{
    /**
     * @var string
     */
    protected $name;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\serviceshelper\otdr\SMTOtdrPulseDto',islist='true')
     * @var app\serviceshelper\otdr\SMTOtdrPulseDto[]
     */
    protected $otdrPulseArray = array();    
    
    /**
     * @var integer[]
     */
    protected $wavelengthArray = array();
    
    /**
     * 
     * @var integger[]
     */
    protected $dwdmFrequenciesArray = array();
    /**
     * @param string $name
     */
    public function setName( $name )
    {
        $this->name = $name;
    }
    
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    
	/**
	 * @param app\serviceshelper\otdr\SMTOtdrPulseDto[] $otdrPulseArray
	 */
	public function setOtdrPulseArray( $otdrPulseArray)
	{
		$this->otdrPulseArray = $otdrPulseArray;
	}

	/**
	 * @return app\serviceshelper\otdr\SMTOtdrPulseDto[]
	 */
	public function getOtdrPulseArray()
	{
		return $this->otdrPulseArray;
	}

	/**
	 * @param app\serviceshelper\otdr\SMTOtdrPulseDto $otdrPulse
	 */
	public function addOtdrPulse( SMTOtdrPulseDto $otdrPulse )
	{
		array_push( $this->otdrPulseArray, $otdrPulse );
	}	
	
	/**
	 * @param int[] $wavelengthArray
	 */
	public function setWavelengthArray( $wavelengthArray )
	{
		$this->wavelengthArray = $wavelengthArray;
	}
	
	/**
	 * @return int[]
	 */
	public function getWavelengthArray()
	{
		return $this->wavelengthArray;
	}
	
	/**
	 * @param int $wavelength
	 */
	public function addDwdmFrequenciesArray( $dwdmFrequency )
	{
		if ( !isset($dwdmFrequency) || $dwdmFrequency=== NULL || !SMTUtil::isInt( $dwdmFrequency) )
	    {
	    	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "dwdmFrequency", $dwdmFrequency);
	    }
	    
	    array_push( $this->dwdmFrequenciesArray, intval($dwdmFrequency) );
	}

	/**
	 * @param int[] $wavelengthArray
	 */
	public function setDwdmFrequenciesArray( $dwdmFrequenciesArray)
	{
		$this->dwdmFrequenciesArray= $dwdmFrequenciesArray;
	}
	
	/**
	 * @return int[]
	 */
	public function getDwdmFrequenciesArray()
	{
		return $this->dwdmFrequenciesArray;
	}
	
	/**
	 * @param int $wavelength
	 */
	public function addWavelength( $wavelength )
	{
		if ( !isset($wavelength) || $wavelength === NULL || !SMTUtil::isInt( $wavelength ) )
		{
			throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "wavelength", $wavelength );
		}
		
		array_push( $this->wavelengthArray, intval($wavelength) );
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Returns the dto class name.
	 *
	 * @return the dto class name.
	 */
	public static function getClass()
	{
		return __CLASS__;
	}	
}
?>