<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2019. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;

/**
 * Container of rotau switch Dto with configured and detected (optional: only if config!=detection)
 *
 * @author Sylvain Desplat
 */
class SMTConfDetRotauDto extends SMTRwDto
{
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTRotauDto',islist='true')
	 * @var array app\services\setup\SMTRotauDto
	 */
	protected $configuredSwitch = array();

	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTRotauDto',islist='true')
	 * @var array app\services\setup\SMTRotauDto
	 */
	protected $detectedSwitch = array();

	/**
	 * Whether there is a difference between the configuration and the detection.
	 * By default, there is no difference.
	 * @var boolean
	 */
	protected $switchDifferences = array();
	
	/**
	 *
	 * @param array $switchDifferences
	 */
	function setSwitchDifferences( array $switchDifferences = NULL )
	{
		$this->switchDifferences = $switchDifferences;
	}
	
	/**
	 *
	 * @param boolean $switchDifference
	 */
	function addSwitchDifference( $index, $switchDifference )
	{
		$this->switchDifferences[$index] = $switchDifference;
	}

	/**
	 *
	 * @return boolean $switchDifference
	 */
	function getSwitchDifference($index)
	{
		return $this->switchDifferences[$index];
	}

	/**
	 *
	 * @return array of boolean $switchDifference
	 */
	function getSwitchDifferences()
	{
		return $this->switchDifferences;
	}
	/**
	 *
	 * @param app\services\setup\SMTRotauDto $switch
	 */
	function addConfigured( SMTRotauDto $switch )
	{
	    array_push( $this->configuredSwitch, $switch );
	}

	/**
	 *
	 * @param app\services\setup\SMTRotauDto $switch
	 */
	function addDetected( SMTRotauDto $switch )
	{
	    array_push( $this->detectedSwitch, $switch );
	}

	/**
	 *
	 * @param array app\services\setup\SMTRotauDto $switches
	 */
	function setConfigured( $switches )
	{
	    if ($switches != NULL)
	    {
    	    foreach($switches as $switch)
    	    {
    		    array_push( $this->configuredSwitch, $switch );
    	    }
	    }
	}
	
	/**
	 *
	 * @param array app\services\setup\SMTRotauDto $switches
	 */
	function setDetected( $switches )
	{
	    if ($switches != NULL)
	    {
    	    foreach($switches as $switch)
    	    {
    		    array_push( $this->detectedSwitch, $switch );
    	    }
	    }
	}
	
	/**
	 * 
	 * @return array app\services\setup\SMTRotauDto $switches:
	 */
	function getDetected()
	{
	     return $this->detectedSwitch;
	}
	
	/**
	 *
	 * @return app\services\setup\SMTRotauDto $switches:
	 */
	function getRotauDetected($indexMacroSwitch)
	{
		$rotau = NULL;
		foreach($this->detectedSwitch as $switch)
		{
			if ( $switch->getIndex() === $indexMacroSwitch )
			{
				$rotau = $switch;
			}
		}
		return $rotau;
	}
	
	/**
	 *
	 * @return true if the ROTAU is detected
	 */
	function isRotauDetected($indexMacroSwitch)
	{
		return $this->getRotauDetected($indexMacroSwitch) != NULL;
	}
	
	/**
	 * Serialize as Json data the object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTConfDetSwitchDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}

?>