<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\otdr;

use app\util\SMTDto;
use app\serviceshelper\otdr\SMTOtdrTraceType;
use app\serviceshelper\otdr\SMTTraceFileType;

/**
 * Otdr acquisition DTO embedding the sor file binary buffer encoded in an Hexadecimal string.
 * 
 * @author Sylvain Desplat
 */
class SMTOtdrTraceDto extends SMTDto
{
    /**
     * OTDR file name without its path 
     * 
     * @var string
     */
    protected $otdrTraceName;
    
    /**
     * Whether the OTDR trace name is a reference trace, a new acquisition trace stored in SmartOTU directory or the last monitoring trace acquisition.
     *
     * @param string SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
     */
    protected $otdrTraceType = SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE;
    
    /**
     * File extension
     * @var string SMTTraceFileType::SOR, ...
     */
    protected $otdrFileType = SMTTraceFileType::SOR;
    
    /**
     * OTDR binary trace buffer encoded in an hexadecimal string
     * @var string
     */
    protected $otdrTraceBuffer;
    
    /**
     * @var boolean
     */
    protected $smartAcq = FALSE;
    
    /**
     * SOM value
     * @var float
     */
    protected $som = 0.0;
    
    /**
     * EOM value
     * @var float
     */
    protected $eom = 0.0;
    
    /**
     * Set OTDR file name without its path 
     * 
     * @param string $otdrTraceName
     */
    public function setOtdrTraceName( $otdrTraceName)
    {
    	$this->otdrTraceName = $otdrTraceName;
    }
    
    /**
     * get OTDR file name without its path
     *  
     * @return string
     */
    public function getOtdrTraceName()
    {        
    	return $this->otdrTraceName;
    } 
    
    /**
     * Whether the OTDR trace name is a reference trace, a new acquisition trace stored in SmartOTU directory or the last monitoring trace acquisition.
     *
     * @param string SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
     */
    function setOtdrTraceType( $otdrTraceType )
    {
    	$this->otdrTraceType = $otdrTraceType;
    }
    
    /**
     * 
     * @return string SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
     */
    function getOtdrTraceType()
    {
    	return $this->otdrTraceType;
    }    
    
    /**
     * Whether the OTDR trace name is a SOR, CSOR acquisition trace.
     *
     * @param string SMTTraceFileType::SOR, SMTTraceFileType::CSOR, SMTTraceFileType::MSOR, SMTTraceFileType::DTS
     */
    function setOtdrFileType( $otdrFileType)
    {
    	$this->otdrFileType = $otdrFileType;
    }
    
    function getOtdrFileType()
    {
    	return $this->otdrFileType;
    }    
    
    /**
     *
     * @param string $otdrTraceBuffer
     */
    public function setOtdrTraceBuffer( $otdrTraceBuffer )
    {
    	$this->otdrTraceBuffer = $otdrTraceBuffer;
    }
    
    /**
     *
     * @return string
     */
    public function getOtdrTraceBuffer()
    {
    	return $this->otdrTraceBuffer;
    }    
    
    /**
     * @param string $smartAcq
     */
    public function setSmartAcq( $smartAcq)
    {
    	$this->smartAcq= $smartAcq;
    }
    /**
     * @return $range
     */
    public function getSmartAcq()
    {
    	return $this->smartAcq;
    }
    
    function setSOM($value)
    {
    	$this->som = floatval($value);
    }
    
    function getSOM()
    {
    	return $this->som;
    }
    
    function setEOM($value)
    {
    	$this->eom = floatval($value);
    }
    
    function getEOM()
    {
    	return $this->eom;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json data array.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }    
}
?>