<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution2024. All rights reserved.
// *********************************************************
namespace app\services\api;



use app\events\operations\SMTOperationEventDto;

class SMTApiMeasureInstrumentStatusDto extends SMTApiDto
{
    const MEASURE_STARTED='started';
	const MEASURE_IN_PROGRESS='inProgress';
	const MEASURE_ALREADY_RUNNING='measureAlreadyRunning';
	const MEASURE_PORT_NOT_AVAILABLE='portNotAvailable';
	const MEASURE_RESULT_AVAILABLE='available';
	const MEASURE_FAILED='failure';
	
	/**
	 * Test on demand status
	 *
	 * @var string
	 */
	protected $status = self::SUCCESS;
	
	public function setStatus($status)
	{
		$this->status = $status;
	}
	
	public function getStatus()
	{
		return $this->status;
	}
	
	public static function createMeasureInstrumentStatusApi( $status )
	{
	    $measureInstrumentStatusApi = new SMTApiMeasureInstrumentStatusDto();

	    switch ($status)
	    {
	    case SMTOperationEventDto::IN_PROGRESS:
	        $measureInstrumentStatusApi->setStatus(self::MEASURE_IN_PROGRESS);
	        break;
	    case SMTOperationEventDto::WAITING:
	        $measureInstrumentStatusApi->setStatus(self::MEASURE_STARTED);
	        break;
	    case SMTOperationEventDto::NO_PROGRAMMED:
	    case SMTOperationEventDto::AVAILABLE:
	        $measureInstrumentStatusApi->setStatus(self::MEASURE_RESULT_AVAILABLE);
	        break;
	    case SMTOperationEventDto::FAILED:
	    default:
	        $measureInstrumentStatusApi->setStatus(self::MEASURE_FAILED);
	        break;
	    }
	    return $measureInstrumentStatusApi;
	}
	
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}    
}