<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\events\activity;

use app\services\activity\SMTActivityDto;

use app\events\SMTEventDto;

/**
 * Activity event
 * 
 * @author Sylvain Desplat
 *
 */
class SMTActivityMessageEventDto extends SMTEventDto
{           
    /**
     * Activity event key
     * 
     * @var string
     */
    const ACTIVITY="ACTIVITY";
    
    /**
     * 
     * @SMTAttributeInfosAnnotation(classname='app\services\activity\SMTActivityDto')
     * @var SMTActivityDto
     */
    protected $activity = NULL; 
        
    function getActivity()
    {
    	return $this->activity;
    }    
    
    function setActivity( SMTActivityDto $activity )
    {
    	$this->activity = $activity;
    	$this->id = self::generateActivityId();
    } 
    
    /**
     * Generate the activity identifier: "ACTIVITY" + current date with seconds separated from microseconds by underscore.
     *
     * @return string the activity identifier.
     */
    public static function generateActivityId()
    {
    	return self::ACTIVITY.preg_replace("/[^0-9]/i", '_', microtime(true) );
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }        
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return app\events\activity\SMTActivityMessageEventDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }
}

?>