<?php

// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\events;

use app\services\activity\SMTActivityDto;

use app\services\alarm\SMTAlarmDto;

use app\services\monitoring\SMTLinkTestDto;

use app\events\linktest\SMTLinkTestUpdateEventDto;

use app\events\operations\SMTOperationEventDto;
use app\services\alarm\otu\SMTOtuAlarmDto;

/**
 * Notify operation events to the event manager.
 * 
 *
 * @author Sylvain Desplat
 */
interface SMTIEventMessageProducer
{
    /**
     * Add the alarm to the alarm messages to be sent if consumers are registered.
     *
     * @param SMTAlarmDto $alarmDto The alarm dto to notify to clients
     */
	function sendAlarmEvent(  $alarms, SMTOtuAlarmDto $otuAlarm /*SMTAlarmDto $alarmDto*/ );
    
    /**
     * Add the activity to the activity messages to be sent if consumers are registered.
     *
     * @param SMTActivityDto $activityDto The activity
     */
    function sendActivityEvent( SMTActivityDto $activityDto );

    /**
     * Add the operation event (test on demand, measurement) to the corresponding operation message listener.
     *
     * @param SMTOperationEventDto event The operation event to add to the operation message and to be sent to the consumer.
     */
    function sendOperationEvent( SMTOperationEventDto $event );
    
    /**
     * Create and add the link-test update event to the link-test update messages to notify consumers of an update of all the link-test DTO
     *
     */
    function createAndSendLinkTestUpdateAllEvent();
    
    /**
     * Create and add the link-test update event to the link-test update messages to notify consumers of an update of the link-test DTO
     *
     * @param SMTLinkTestDto $linkTest The link-test DTO updated
     */
    function createAndSendLinkTestUpdateEvent( SMTLinkTestDto $linkTest );
    
    /**
     * Send the link-test update event to the link-test update messages to notify consumers of an update of the link-test DTO
     * 
     * @param SMTLinkTestUpdateEventDto $event The link-test update event embedding the link-test DTO updated; If $linkTest is null, ask an update of all the link-test
     */
    function sendLinkTestUpdateEvent( SMTLinkTestUpdateEventDto  $event );
    
    /**
     * Whether there are activity message consumers registered
     *
     * @return Whether there are activity message consumers registered
     */
    function hasActivityConsumersRegistered();
}
?>