#!/bin/sh
# 4 parameters : 
# $1 : ISU TCP port
#echo "param 1 TCP port ="$1
# $2 : module position
#echo "param 2 Module position = "$2
# $3 : functiion name
#echo "param 3 function name = "$3
# $4 : function state ON or OFF
#echo "param 4 function state = "$4

exec 5<>/dev/tcp/127.0.0.1/$1
echo "*rem">&5

# start Fiber optic application if not started
echo "PROC:STATUS? \"Fiber_Optic\"">&5
read activate<&5

if [[ $activate != "ACTIVATED" ]]
then
	# start FO
	echo "PROC:FRESHSTART \"Fiber_Optic\"">&5
	
	# and wait for activated
	while [[ $activate != "ACTIVATED" ]]
	do
		sleep 1
		echo "PROC:STATUS? \"Fiber_Optic\"">&5
		read activate<&5
		#echo "activate ="$activate
	done
	/acterna/release/bin/cmsend guitaskmgr cmd create_task Fibre-App -name 'Fiber-UI'
	/acterna/release/bin/cmsend guitaskmgr cmd start_task Fiber-UI
fi

# selection or deselect
echo "MOD:FUNC:SEL "$2",\""$3"\","$4>&5
echo "*esr?">&5
read esr<&5

# new current page for selection
if [[ $4 == "ON" ]]
then
	echo "MOD:FUNC:CURR "$2",\""$3""\">&5
	echo "*esr?">&5
	read esr<&5
fi

# Ask task manager to take the focus
/acterna/release/bin/cmsend guitaskmgr cmd raise_task Fiber-UI 
