from viavi.evm import *
from viavi.diag import *
import time

#=============================================================================================
#
# /usr/share/pydiag/oth
#
# t_psb_led_set OPTIC-GREEN-ON
# t_psb_led_set OPTIC-GREEN-OFF
# t_psb_led_set OPTIC-RED-ON
# t_psb_led_set OPTIC-RED-OFF
#
# t_psb_led_set UNIT-GREEN-ON
# t_psb_led_set UNIT-GREEN-OFF
# t_psb_led_set UNIT-RED-ON
# t_psb_led_set UNIT-RED-OFF
#
# t_psb_led_set SERVER-GREEN-ON
# t_psb_led_set SERVER-GREEN-OFF
# t_psb_led_set SERVER-RED-ON
# t_psb_led_set SERVER-RED-OFF
#
# t_psb_led_set STATUS-GREEN-ON
# t_psb_led_set STATUS-GREEN-OFF
# t_psb_led_set STATUS-RED-ON
# t_psb_led_set STATUS-RED-OFF
#
# t_psb_led_set TEST-GREEN-ON
# t_psb_led_set TEST-GREEN-OFF
# t_psb_led_set TEST-RED-ON
# t_psb_led_set TEST-RED-OFF
#=============================================================================================


@DIAG("Set ON/OFF PSB front panel leds")
def t_psb_led_set(cmd):
    
    debug = False
    
    try:
        (command,consigne) = cmd.split()
        
        my_string = consigne.split('-')

    except:
        print_error("   Syntax error : Command must be : t_psb_led_set <consigne>")
        print_error("   where <consigne> is <LED_TYPE>-<LED_COLOR>-<ON_OFF>")
        print_error("   with  <LED_TYPE>    = OPTIC|UNIT|SERVER|STATUS|TEST|ALL")
        print_error("         <LED_COLOR>   = RED|GREEN")
        print_error("         <ON_OFF>      = ON|OFF")
        return False
    
    #print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    print_info("* consigne is "+consigne)
    (led_type_list, led_color, OnOff_flag) = consigne.split('-')
    print_info("     * led_type_list is "+led_type_list)
    print_info("     * led_color     is "+led_color)
    print_info("     * OnOff_flag    is "+OnOff_flag+"\n")

    led_type_name_list = ["OPTIC", "UNIT", "SERVER", "STATUS", "TEST"]

    todo_list = ["NO", "NO", "NO", "NO", "NO"]

    # Arguments verification

    arg_list = led_type_list.split('|')
    if debug:
        print("     * arg_list is ", arg_list,"\n")

    for elt in enumerate(arg_list):
        if debug:
            print(elt)
        if elt[1] not in led_type_name_list:
            if elt[1] != 'ALL':
                print("Error : ", elt[1], "is not a correct arg")
                return False

    if led_color == "GREEN" or led_color == "RED":
        if debug:
            print("led_color is OK")
    else:
        print("led_color is undefined : MUST be GREEN or RED")
        return False

    if OnOff_flag == "ON" or OnOff_flag == "OFF":
        if debug:
            print("OnOff_flag is OK")
    else:
        print("On-OFF is undefined : MUST be ON or OFF")
        return False

    # Argument extraction

    if 'ALL' in arg_list:
        i = 0
        while i < len(led_type_name_list):
            todo_list[i] = "YES"
            i += 1
    else:
        i = 0
        for elt in enumerate(led_type_name_list):
            if elt[1] in arg_list:
                todo_list[i] = "YES"
            i += 1

    if OnOff_flag == "ON":
        s = "255"
        msg = "Set_on"
    else:
        s = "0"
        msg = "Clear"

    i = 0
    while i < len(led_type_name_list):

        if debug:
            print("     * led_type_name_list[%d] = "%i, led_type_name_list[i])
            print("     * todo_list[%d] = "%i, todo_list[i])

        if todo_list[i] == 'YES':

            color_str = led_color.lower()
            led_type_str = led_type_name_list[i].lower()
            print("%s led %s %s " %(msg, led_type_str,color_str))

            if debug:
                os_cmde = "/sys/class/leds/"+led_type_str+":"+color_str+"/brightness"

                print("cmde is : echo %s >" %s, os_cmde)

            sysfs_write("/sys/class/leds/"+led_type_str+":"+color_str+"/brightness", s)
        i += 1

    return None
#
#=============================================================================================
#
# t_psb_pwr_status FRONT-RIGHT
# t_psb_pwr_status FRONT-LEFT
# t_psb_pwr_status FRONT-BOTH
# t_psb_pwr_status REAR-RIGHT
# t_psb_pwr_status REAR-LEFT
# t_psb_pwr_status REAR-BOTH
# t_psb_pwr_status BOTH-RIGHT
# t_psb_pwr_status BOTH-LEFT
# t_psb_pwr_status BOTH-BOTH
#
#=============================================================================================
#

@DIAG("PSB 48V Power supply status readback")
def t_psb_pwr_status(cmd):

    debug = False

    try:
        (command,consigne) = cmd.split()

    except:
        print_error("   Syntax error : Command must be : t_psb_pwr_status <consigne>")
        print_error("   where             <consigne>  <PANEL_LOC>-<SIDE>")
        print_error("   with              <PANEL_LOC> = FRONT|REAR|BOTH")
        print_error("                     <SIDE>      = RIGHT|LEFT|BOTH")
        return False

    #print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    (panel_loc, side) = consigne.split('-')

    arg_loc_list = panel_loc.split('|')
    arg_side_list = side.split('|')

    if debug:
        print("     * arg_loc_list is ", arg_loc_list,"")
        print("     * arg_side_list is ", arg_side_list)
        print("")

    panel_loc_name_list = ['FRONT', 'REAR']
    side_name_list = ['RIGHT', 'LEFT']
    panel_comb_list = ['FRONT-RIGHT', 'FRONT-LEFT', 'REAR-RIGHT', 'REAR-LEFT']
    todo_list = ['NO', 'NO', 'NO', 'NO']

    # Arguments verification

    for elt in enumerate(arg_loc_list):
        if debug:
            print(elt)
        if elt[1] not in panel_loc_name_list:
            if elt[1] != 'BOTH':
                print("Error : ", elt[1], "is not a correct value for <PANEL_LOC> arg")
                return False

    for elt in enumerate(arg_side_list):
        if debug:
            print(elt)
        if elt[1] not in side_name_list:
            if elt[1] != 'BOTH':
                print("Error : ", elt[1], "is not a correct value for <SIDE> arg")
                return False
    #

    loc_front_flag = 0
    loc_rear_flag = 0

    for elt in enumerate(arg_loc_list):
        if elt[1] == 'BOTH':
            loc_front_flag = 1
            loc_rear_flag = 1
        elif elt[1] == 'FRONT':
            loc_front_flag = 1
        else:
            loc_rear_flag = 1

    side_right_flag = 0
    side_left_flag = 0

    for elt in enumerate(arg_side_list):
        if elt[1] == 'BOTH':
            side_right_flag = 1
            side_left_flag = 1
        elif elt[1] == 'RIGHT':
            side_right_flag = 1
        else:
            side_left_flag = 1
    #

    if loc_front_flag:
        if side_right_flag:
            todo_list[0] = 'YES'
        if side_left_flag:
            todo_list[1] = 'YES'

    if loc_rear_flag:
        if side_right_flag:
            todo_list[2] = 'YES'
        if side_left_flag:
            todo_list[3] = 'YES'

    if debug:
        print("loc_front_flag = %d" %loc_front_flag, "loc_rear_flag = %d" %loc_rear_flag)
        print("side_right_flag = %d" %side_right_flag, "side_left_flag = %d" %side_left_flag)

        for elt in enumerate(todo_list):
            print(elt)

    i = 0
    while i < len(panel_comb_list):

        loc_side = panel_comb_list[i]
        (panel_loc, side) = loc_side.split('-')

        if todo_list[i] == 'YES':

            panel_loc_str = panel_loc.lower()
            side_str = side.lower()

            pwr_value = sysfs_read("/sys/platform/pwr_"+panel_loc_str+"_"+side_str+"/value")

            if pwr_value == 1:
                msg1 = " : present"
            else:
                msg1 = " : absent"

            msg2 = "<%s> power supply <%s>" %(panel_loc, side)
            print_ok(msg2+msg1)
        i += 1

    return None
#
#=============================================================================================
#
@DIAG("PSB Power supply presence test")

def t_psb_pwr_test(cmd):

    debug = False

    try:
        (command,consigne) = cmd.split()
        if debug:
            print("command = ", command, "consigne =", consigne)

        (panel_loc, side, exp_value) = consigne.split('-')
        if debug:
            print("panel_loc is ", panel_loc)
            print("side is ", side)
            print("exp_value is ", exp_value)

        return_flag = True

        if panel_loc != "FRONT" and panel_loc != "REAR":
            print_error("Error : PANEL_LOC undefined : MUST be FRONT or REAR")
            return_flag = False

        if side != "RIGHT" and side != "LEFT":
            print_error("Error : SIDE undefined : MUST be RIGHT or LEFT")
            return_flag = False

        if exp_value == "PRESENT" or exp_value == "ABSENT":
            if exp_value == "PRESENT":
                pwr_exp_value_str = '1'
            else:
                pwr_exp_value_str = '0'
        else:
            print_error("Error : EXP_VALUE undefined : MUST be PRESENT or ABSENT")
            return_flag = False

        if return_flag == False:
            return return_flag

    except:
        print_error("   Syntax error : Command must be : t_psb_pwr_test <consigne>")
        print_error("   where             <consigne>  <PANEL_LOC>-<SIDE>-<EXP_VALUE>")
        print_error("   with              <PANEL_LOC> = FRONT|REAR")
        print_error("                     <SIDE>      = RIGHT|LEFT")
        print_error("                     <EXP_VALUE> = PRESENT|ABSENT")
        return False

    #print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    panel_loc_str = panel_loc.lower()
    side_str = side.lower()

    pwr_value_str = sysfs_read_string("/sys/platform/pwr_"+panel_loc_str+"_"+side_str+"/value")

    if debug:
        print("Readback <%s> power supply <%s> side :" %(panel_loc_str,side_str))
        print("Readback value =  %s"%(pwr_value_str))

    if pwr_value_str[0] == pwr_exp_value_str[0]:
        return True
    else:
        return False
#
#=============================================================================================
#
# PSB i2c devices :
#
#  Identificatyion EEPROM @ I2C_addr = 0x50
#  PCA9535 IO expander @ I2C_addr = 0x20
#  Temperature sensor test @ I2C_addr = 0x48
#  I2C PCA9532_led @ I2C_addr = 0x60
#  I2C PCA9535_gpio_expander @ I2C_addr = 0x20
#
#=============================================================================================
#
@DIAG("PSB i2c devices detection")
def t_psb_i2cdetect(cmd):

    debug = False
    verbose = False

    try:
        if ' ' not in cmd:
            pass
        else:
            (command,consigne) = cmd.split()
            if debug:
                print("arg exist : %s" %consigne)
            if consigne == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : arg must be : verbose\n")
                return False
    except:
        print_error("   Syntax error : Command must be : t_psb_i2cdetect <consigne>\n")

    FileName = "/usr/share/pydiag/oth/psb_i2c_detect_tmp.txt"

    psb_i2c_bus_nb = '0'

    i2c_cmde = "i2cdetect -y "+psb_i2c_bus_nb

    if verbose:
        i2c_bus0_my_list = (os.system(i2c_cmde))

    os_cmde = i2c_cmde+ " > "+FileName

    i2c_bus0_my_list = (os.system(os_cmde))

    if debug:
        print("os_cmde = ", i2c_cmde)

        print("\n================")
        print("**** i2c-%s bus:" %psb_i2c_bus_nb)
        print("================\n")

        print(i2c_bus0_my_list,"\n")                     # return 0 if os.system(i2c_cmde) is successful

    i2c_to_detect_list = ['20', '48', '50', '60']
    i2c_device_list = ['PCA9535', 'Temperature sensor', 'EEPROM ident', 'PCA9532']

    i2c_detected_list = []

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            col = 0
            if ':' in line:
                (addr_list, data_list) = line.split(': ')
                if debug:
                    print("* addr = ", addr_list, " ; data_list = ", data_list)

                var = data_list.split(' ')
                if debug:
                    print("     - var = ", var, " ; length = %d" %len(var))

                if len(var) > 17:
                    j = 0
                    var1 = []
                    while j < len(var):
                        if var[j] == '':
                            var1.append('  ')
                            j += 2
                        else:
                            var1.append(var[j])
                        j += 1

                    if debug:
                        print("         > var1 = ", var1, " ; length = %d" %len(var1))

                    var = var1

                    if debug:
                        print("         > var  = ", var, " ; length = %d" %len(var))

                for elt in enumerate (var):
                    if elt[1] != '  ' and elt[1] != '--' and  elt[1] != '\n':
                        if debug:
                            print("     - elt[%d][%d]" %(int(addr_list), col), "= %s" %elt[1])
                            print("     - elt[%X][%x]" %(int(addr_list, base=16), col), "= %s" %elt[1])
                            
                        i2c_addr = int(addr_list, base=16) + col
                        i2c_addr_h = "%x" %i2c_addr

                        i2c_detected_list.append(i2c_addr_h)
                    col += 1

    tmpfile.close()

    os_cmde = "rm -f "+FileName

    if debug == True:
        print("os_cmde is", os_cmde)

    (os.system(os_cmde))

    if debug:
        print("i2c_detected_list is ", i2c_detected_list)

    pass_flag = True
    for elt in enumerate (i2c_to_detect_list):
        if (elt[1]) in i2c_detected_list:
            if verbose:
                print_ok("I2C device at addr 0x%s" %elt[1]+" detected")
        else:
            if verbose:
                print_error("I2C device at addr 0x%s" %elt[1]+" not detected")
            pass_flag = False

    return pass_flag
#
#=============================================================================================
#
@DIAG("PSB i2c eeprom read")
def t_psb_eeprom_read(cmd):

    eeprom_i2c_bus_nb = "0"
    eeprom_i2c_addr = "0x50"

    i2c_cmde = "i2cdump -y "+eeprom_i2c_bus_nb+" "+eeprom_i2c_addr+" c"

    print("i2c cmde is : ", i2c_cmde)
    (os.system(i2c_cmde))

    return True
#
#=============================================================================================
#
# "PSB_BOARD" is "50 53 42 5f 42 4f 41 52 44"
# Non functional
#
#=============================================================================================
#
@DIAG("PSB i2c eeprom write")

def t_psb_eeprom_write(cmd):

    debug = True

    eeprom_i2c_bus_nb = "0"
    eeprom_i2c_addr = "0x50"

    eeprom_addr = "0x27"
    eeprom_value = "0x0"

    i2c_cmde = "i2cset -f -y "+eeprom_i2c_bus_nb+" "+eeprom_i2c_addr+" "+eeprom_addr+" "+eeprom_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

    return None
#
#=============================================================================================
#
# Capteur de T° : sensors -c /etc/sensors.d/oth_sensors.conf
#
# eeprom_i2c_bus_nb = "0"
# device_i2c_addr = "0x48"
#
#=============================================================================================
#
@DIAG("PSB i2c temperature sensor test")

def t_psb_temp_sensor(cmd):

    debug = False

    try:
        (command, consigne) = cmd.split()

        my_string = consigne.split('-')

        (min_value_str, max_value_str) = consigne.split('-')
        if debug:
            print("min_value_str is ", min_value_str, " ; max_value_str = ", max_value_str)

        min_value = float(min_value_str)
        max_value = float(max_value_str)

        print("min_value = %3.1f ; max_value = %3.1f"  %(min_value, max_value))

    except:
        print_error("   Syntax error : Command must be : t_psb_temp_sensor <consigne>")
        print_error("   where <consigne> is <Min_value>-<Max_value>")
        print_error("   And <Min_value>, <Max_value> MUST be decimal values")

        return False

    FileName = "/usr/share/pydiag/oth/sensor_detect_tmp.txt"

    sensor_cmde = "sensors"

    os_cmde = sensor_cmde+ " > "+FileName

    if debug:
        print("sensor_cmde is ", sensor_cmde)
        print("os_cmde is ", os_cmde)

    (os.system(os_cmde))

    packet_line = []
    psb_temp_found = False

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            if line =='\n':
                if debug:
                    print("-----------------------------------------------------")
                    print("packet_line is -%s-" %packet_line)

                # packet_line traitment

                for elt in packet_line:
                    if debug:
                        print("elt = ", elt)
                if "psb_temp:" in elt:
                    (sensor_device, temp) = elt.split(':')
                    temp_list = temp.split(' ')
                    if debug:
                        print("********************* packet_line ttt **********")
                        print("     * sensor_device = ", sensor_device, " ; temp = ", temp)
                        print("     * temp_list = ", temp_list)
                        print("     * temp_list[5] = ", temp_list[5])
                    psb_temp_found = True
                    psb_temp = temp_list[5]

                packet_line = []
            else:
                packet_line.append(line)

    tmpfile.close()

    os_cmde = "rm -f "+FileName

    if debug == True:
        print("os_cmde is", os_cmde)

    (os.system(os_cmde))

    if psb_temp_found:
        print("psb temperature = %3.1f" %float(psb_temp))
        if float(psb_temp) > min_value and float(psb_temp) < max_value:
            return True
        else:
            return False
    else:
        print("psb temperature not found")
        return False
#
#=============================================================================================
#
# t_psb_PCA9535_gpio_read : to test the I2C GPIO expander
#
# 0x0 : INPUT0  READ        Input port 0 register
# 0x1 : INPUT1  READ        Input port 1 register
# 0x2 : OUTPUT0 READ/WRITE  Output port 0 register
# 0x3 : OUTPUT1 READ/WRITE  Output port 1 register
# 0x4 : POLINV0 READ/WRITE  Polarity inversion port 0 register
# 0x5 : POLINV1 READ/WRITE  Polarity inversion port 1 register
# 0x6 : CFG0    READ/WRITE  Configuration port 0 register
# 0x7 : CFG1    READ/WRITE  Configuration port 1 register
#
# more psb_i2c_PCA9535_tmp.txt
#      0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f    0123456789abcdef
# 00: 48 00 ff ff 00 00 ff ff                            H......
#
# nPRES_48V_FP1 (U10-P12)   -- J1 (Right) Front panel power supply
# nPRES_48V_FP2 (U10-P13)   -- J2 (Left)  Front panel power supply
# nPRES_48V_RP1 (U10-P02)   -- J3 (Left)  Rear panel power supply
# nPRES_48V_RP2 (U10-P03)   -- J4 (Right) Rear panel power supply
#
#=============================================================================================
#
@DIAG("PSB i2c PCA9535_GPIO_EXPANDER registers read")
def t_psb_PCA9535_gpio_read(cmd):

    debug = False
    verbose = False

    try:
        if ' ' not in cmd:
            pass
        else:
            (command,consigne) = cmd.split()
            if debug:
                print("arg exist : %s" %consigne)
            if consigne == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : arg must be : verbose\n")
                return False

    except:
        print_error("   Syntax error : Command must be : t_psb_PCA9535_gpio_read <consigne>\n")

    device_i2c_bus_nb = "0"
    device_i2c_addr = "0x20"
    device_reg_addr_first = "0x00"
    device_reg_addr_last = "0x07"

    i2c_cmde = "i2cdump -f -y -r "+device_reg_addr_first+"-"+device_reg_addr_last+" "+device_i2c_bus_nb+" "+device_i2c_addr

    print("i2c cmde is : ", i2c_cmde)
    (os.system(i2c_cmde))

    FileName = "/usr/share/pydiag/oth/psb_i2c_PCA9535_tmp.txt"

    os_cmde = i2c_cmde+ " > "+FileName
    (os.system(os_cmde))

    if verbose:
        print("")

    # traitement

    i2c_reg_name_list = ["INPUT0", "INPUT1", "OUTPUT0", "OUTPUT1", "POLINV0", "POLINV1", "CFG0", "CFG1"]

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            if debug:
                print("line is", line)
            if ':' in line:
                (addr_list, data_list) = line.split(': ')
                if debug:
                    print("* addr = ", addr_list, " ; data_list = ", data_list)

    tmpfile.close()

    var = data_list.split(' ')
    if debug:
        print("var is", var)

    if verbose:
        for elt in enumerate (var):
            if int(elt[0]) < 8:
                print("@ addr %d" %elt[0], ";", "%s register = 0x%s" %(i2c_reg_name_list[int(elt[0])], elt[1]))
                if elt[0] == 0:
                    reg_value = int(elt[1], base=16)
                    bit_0 = reg_value & 0x1
                    bit_1 = int((reg_value & 0x2)/2)
                    bit_2 = int((reg_value & 0x4)/4)
                    bit_3 = int((reg_value & 0x8)/8)
                    bit_4 = int((reg_value & 0x10)/16)
                    bit_5 = int((reg_value & 0x20)/32)
                    bit_6 = int((reg_value & 0x40)/64)
                    bit_7 = int((reg_value & 0x80)/128)

                    print("     - INPUT0_reg[0] = 0x%x" %bit_0)
                    print("     - INPUT0_reg[1] = 0x%x" %bit_1)
                    print("     - INPUT0_reg[2] = 0x%x" %bit_2, ": nPRES_48V_RP1 - Rear Left  (J3)")
                    print("     - INPUT0_reg[3] = 0x%x" %bit_3, ": nPRES_48V_RP2 - Rear Right (J4)")
                    print("     - INPUT0_reg[4] = 0x%x" %bit_4)
                    print("     - INPUT0_reg[5] = 0x%x" %bit_5)
                    print("     - INPUT0_reg[6] = 0x%x" %bit_6, ": LED_RESET_N")
                    print("     - INPUT0_reg[7] = 0x%x" %bit_7)
                if elt[0] == 1:
                    reg_value = int(elt[1], base=16)
                    bit_0 = reg_value & 0x1
                    bit_1 = int((reg_value & 0x2)/2)
                    bit_2 = int((reg_value & 0x4)/4)
                    bit_3 = int((reg_value & 0x8)/8)
                    bit_4 = int((reg_value & 0x10)/16)
                    bit_5 = int((reg_value & 0x20)/32)
                    bit_6 = int((reg_value & 0x40)/64)
                    bit_7 = int((reg_value & 0x80)/128)

                    print("     - INPUT1_reg[0] = 0x%x" %bit_0)
                    print("     - INPUT1_reg[1] = 0x%x" %bit_1)
                    print("     - INPUT1_reg[2] = 0x%x" %bit_2, ": nPRES_48V_FP1 - Front Right (J1)")
                    print("     - INPUT1_reg[3] = 0x%x" %bit_3, ": nPRES_48V_FP2 - Front Left  (J2)")
                    print("     - INPUT1_reg[4] = 0x%x" %bit_4)
                    print("     - INPUT1_reg[5] = 0x%x" %bit_5)
                    print("     - INPUT1_reg[6] = 0x%x" %bit_6)
                    print("     - INPUT1_reg[7] = 0x%x" %bit_7)
            else:
                break

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))
#
#=============================================================================================
#
# t_psb_PCA9532_led_read : to test the led driver
#
# 0x0 : INPUT0  READ        Input Register 0
#
#           |-------|-------|-------|-------|-------|-------|-------|-------|
#           |  LED7 |  LED6 |  LED5 |  LED4 |  LED3 |  LED2 |  LED1 |  LED0 |
#           |-------|-------|-------|-------|-------|-------|-------|-------|
#       Bit |   7   |   6   |   5   |   4   |   3   |   2   |   1   |   0   |
#           |-------|-------|-------|-------|-------|-------|-------|-------|
#
# 0x1 : INPUT1  READ        Input Register 1
#           |-------|-------|-------|-------|-------|-------|-------|-------|
#           | LED15 | LED14 | LED13 | LED12 | LED11 | LED10 |  LED9 |  LED8 |
#           |-------|-------|-------|-------|-------|-------|-------|-------|
#       Bit |   7   |   6   |   5   |   4   |   3   |   2   |   1   |   0   |
#           |-------|-------|-------|-------|-------|-------|-------|-------|
#
# 0x2 : PSC0    READ/WRITE  Frequency Prescaler 0
#
# 0x3 : PWM0    READ/WRITE  PWM Register 0
# 0x4 : PSC1    READ/WRITE  Frequency Prescaler 1
# 0x5 : PWM1    READ/WRITE  PWM Register 1
#
# 0x6 : LS0     READ/WRITE  LED 0-3 Selector  (led0 = STATUS_Red ; led1 = STATUS_Green ;
#                                              led2 = TEST_Red ; led3 = TEST_Green)
#       Ex : LS0 :
#
#           |-------|-------|-------|-------|
#           |  LED3 |  LED2 |  LED1 |  LED0 |
#           |-------|-------|-------|-------|
#       Bit | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
#           |-------|-------|-------|-------|
#
#       LS0(1:0) = 00 : Led0 output set Hi-Z
#                  01 : Led0 On (output set @ 0)
#                  10 : led0 blinks at BLINK0 Rate
#                  11 : led0 blinks at BLINK1 Rate
#
# 0x7 : LS1     READ/WRITE  LED 4-7 Selector  (led4 = SERVER_Red ; led5 = SERVER_Green ;
#                                              led6 = OPTIC_Red ; led7 = OPTIC_Green)
#
# 0x8 : LS2     READ/WRITE  LED 8-11 Selector (led8 = UNIT_Red ; led9 = UNIT_Green ;
#                                             (led10, led11) unused
#
# 0x9 : LS3     READ/WRITE  LED 12-15 Selector : unused
#
# more psb_i2c_PCA9532_tmp.txt
#      0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f    0123456789abcdef
# 00: 00 00 00 00 00 00 44 44 04 00          ......DD?.
#
#=============================================================================================
#
@DIAG("PSB i2c PCA9532_led registers read")
def t_psb_PCA9532_led_read(cmd):

    debug = False
    verbose = False

    try:
        if ' ' not in cmd:
            pass
        else:
            (command,consigne) = cmd.split()
            if debug:
                print("arg exist : %s" %consigne)
            if consigne == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : arg must be : verbose\n")
                return False

    except:
        print_error("   Syntax error : Command must be : t_psb_PCA9532_led_read <consigne>\n")

    device_i2c_bus_nb = "0"
    device_i2c_addr = "0x60"
    device_reg_addr_first = "0x00"
    device_reg_addr_last = "0x09"

    i2c_cmde = "i2cdump -f -y -r "+device_reg_addr_first+"-"+device_reg_addr_last+" "+device_i2c_bus_nb+" "+device_i2c_addr

    print("i2c cmde is : ", i2c_cmde)
    (os.system(i2c_cmde))

    FileName = "/usr/share/pydiag/oth/psb_i2c_PCA9532_tmp.txt"

    os_cmde = i2c_cmde+ " > "+FileName
    (os.system(os_cmde))

    if verbose:
        print("")

    # traitement

    i2c_reg_name_list = ["INPUT0", "INPUT1", "PSC0", "PWM0", "PSC1", "PWM1", "LS0", "LS1", "LS2", "LS3"]

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            if debug:
                print("line is", line)
            if ':' in line:
                (addr_list, data_list) = line.split(': ')
                if debug:
                    print("* addr = ", addr_list, " ; data_list = ", data_list)

    tmpfile.close()

    var = data_list.split(' ')
    if debug:
        print("var is", var)

    for elt in enumerate (var):
        if int(elt[0]) < 10:
            if verbose:
                print("@ addr %d" %elt[0], " ; ", "%s register = 0x%s" %(i2c_reg_name_list[int(elt[0])], elt[1]))
        else:
            break

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))
#
#=============================================================================================
#
#=============================================================================================
#
@DIAG("PSB i2c PCA9532_led write")
def t_psb_PCA9532_led_write(cmd):

    debug = True

    device_i2c_bus_nb = "0"
    device_i2c_addr = "0x60"
    INPUT0_addr = '0x0'
    INPUT0_addr = '0x1'
    PSC0_addr = '0x2'
    PWM0_addr = '0x3'
    PSC1_addr = '0x4'
    PWM1_addr = '0x5'
    LS0_addr  = '0x6'
    LS1_addr  = '0x7'
    LS2_addr  = '0x8'
    LS3_addr  = '0x9'

#   Prescaler0 frequency

    PSC0_value = 75
    T_BLINK0 = int(PSC0_value / 152)

    i2c_cmde = "i2cset -f -y "+device_i2c_bus_nb+" "+device_i2c_addr+" "+PSC0_addr+" "+ "0x%x"%PSC0_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

#   Prescaler0 dimming

    PWM0_value = 64
    DutyCycle0_value = PWM0_value / 256

    i2c_cmde = "i2cset -f -y "+device_i2c_bus_nb+" "+device_i2c_addr+" "+PWM0_addr+" "+ "0x%x"%PWM0_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

#   Prescaler1 frequency

    PSC1_value = 25
    T_BLINK1 = int(PSC1_value / 152)

    i2c_cmde = "i2cset -f -y "+device_i2c_bus_nb+" "+device_i2c_addr+" "+PSC1_addr+" "+ "0x%x"%PSC1_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

#   Prescaler1 dimming

    PWM1_value = 128
    DutyCycle0_value = PWM1_value / 256

    i2c_cmde = "i2cset -f -y "+device_i2c_bus_nb+" "+device_i2c_addr+" "+PWM1_addr+" "+ "0x%x"%PWM1_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

    Led_off    = 0x0
    Led_on     = 0x1
    Led_blink0 = 0x2
    Led_blink1 = 0x3

    LED1_STATUS_red   = Led_on
    LED1_STATUS_green = Led_off
    LED2_TEST_red     = Led_blink1
    LED2_TEST_green   = Led_on

    LS0_value = (LED2_TEST_green * 64) | (LED2_TEST_red * 16) | (LED1_STATUS_green * 4) | LED1_STATUS_red

    if debug:
        print("LS0 is 0x%x" %LS0_value)

    i2c_cmde = "i2cset -f -y "+device_i2c_bus_nb+" "+device_i2c_addr+" "+LS0_addr+" "+ "0x%x"%LS0_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

    LED3_SERVER_red   = Led_off
    LED3_SERVER_green = Led_off
    LED4_OPTIC_red    = Led_off
    LED4_OPTIC_green  = Led_blink0

    LS1_value = (LED4_OPTIC_green * 64) | (LED4_OPTIC_red * 16) | (LED3_SERVER_green * 4) | LED3_SERVER_red

    if debug:
        print("LS1 is 0x%x" %LS1_value)

    i2c_cmde = "i2cset -f -y "+device_i2c_bus_nb+" "+device_i2c_addr+" "+LS1_addr+" "+ "0x%x"%LS1_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

    LED5_UNIT_red   = Led_blink1
    LED5_UNIT_green = Led_off
    LED6_unused    = Led_off
    LED6_unused    = Led_off

    LS2_value = (LED6_unused * 64) | (LED6_unused * 16) | (LED5_UNIT_green * 4) | LED5_UNIT_red

    if debug:
        print("LS2 is 0x%x" %LS2_value)

    i2c_cmde = "i2cset -f -y "+device_i2c_bus_nb+" "+device_i2c_addr+" "+LS2_addr+" "+ "0x%x"%LS2_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))
