from viavi.evm import *
from viavi.diag import *
import subprocess

@DIAG("System cmd")
def system_cmd(cmd):
    systemcmd = " ".join(cmd.split(" ")[1:])
    p = subprocess.Popen(systemcmd, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        print_info("# %s" % (l.decode("utf-8").strip()))
    return err == 0


@DIAG("Platform Version")
def platform_version(cmd):
    with open("/etc/os-release") as osr:
        for line in osr:
            s = line.split("=")
            if s[0] == "VERSION_ID":
                v = s[1].strip().strip("\"")
                print_info("# Version: %s" % v)
                return
