import QtQuick 2.1
import common 1.0

Image { id: zoomHint

    signal zoomInX
    signal zoomOutX
    signal zoomInY
    signal zoomOutY
    signal centerPressed

    property alias centerHintSource: centerHint.source
    property alias centerHintVisible: centerHint.visible

    anchors.fill: parent
    source: theme.custImageDir + "zoom-hint.png"
    fillMode: Image.Pad

    MouseArea {
        anchors.fill: parent
        onClicked: {
            var xpos = mouse.x / width;
            var ypos = mouse.y / height;
            var zoomIn = xpos > ypos;
            if ((xpos + ypos) < 1) {
                if (zoomIn)
                    zoomInY();
                else
                    zoomOutX();
            } else {
                if (zoomIn)
                    zoomInX();
                else
                    zoomOutY();
            }
        }
    }

    MouseArea {
        anchors.centerIn: parent
        width: 128; height: 128
        onClicked: centerPressed();

        Image { id: centerHint
            anchors.fill: parent
            fillMode: Image.Pad
            opacity: 0.5
        }
    }
}
