import threading


class Environment(object):
    '''
    Class like a dict, but, use a Mutex
    '''

    def __init__(self):
        '''
        Constructor
        __data is the dict
        '''
        self.__mutex = threading.BoundedSemaphore(1)
        self.__data = {}

    def keys(self):
        '''
        Return list of all items name
        '''
        dic = list(self.__data.keys())
        dic.sort()
        return dic

    def delete(self, key):
        '''
        Remove an item from __data
        '''
        if key in self.__data:
            del self.__data[key]

    def __call__(self, name, value=None):
        if value is None:
            self.__mutex.acquire()
            if name in self.__data:
                res = self.__data[name]
            else:
                res = ""
            self.__mutex.release()
            return res
        else:
            self.__mutex.acquire()
            self.__data[name] = value
            self.__mutex.release()

    def value(self,name,default):
        res = default
        self.__mutex.acquire()
        if name in self.__data:
            res = self.__data[name]
        self.__mutex.release()
        return res

    @classmethod
    def create(cls):
        if "environment" not in __builtins__.keys():
            __builtins__["environment"] = cls()
        return __builtins__["environment"]
