#!/usr/bin/env bash
# Init/De-Init script for OTH Backplane Board 7000 (OBB7000)
# This board is exclusive to FTH-7000 and replaces FTH-9000's OSB

init_obb7000_init()
{
	echo -n "OBB7000"

	# Check if the OBB7000 is detected - If not, do nothing
	# (ie is there a MAX6639 chip @ 0x2e ?)
	ls -lAh /sys/bus/i2c/devices/ | grep -q "002e"
	[ $? -ne 0 ] && echo " - Not found, continuing" && return 1 || echo

	# Ensure it is powered on
	GPIO_CHIP=$(ls -lAh /sys/class/gpio/ | awk '/\/5-0021\// {print $9}' | grep chip)
    GPIO_NUMBER=${GPIO_CHIP:8}
	echo 1 > /sys/class/gpio/gpio${GPIO_NUMBER}/value

	# Set mode to 0x04 as it is required for communicating with internal and external switches
	/usr/bin/hamma action.write port.moduleSelector.MODULE_SEL value.0x04
}
