#!/bin/bash

LEASE=0
LEASES_FILE=`ps auxww | grep -- "-lf .*\.lease" | grep -v grep | grep -v sed | sed 's{^.*-lf \(.*\.lease\).*{\1{'`
CONFFILE=/tmp/ztp.conf
APPLISCRIPT=/usr/bin/apply_ztp_conf

logger -t $0 $LEASES_FILE" file will be used"
# Split file
rm -rf /tmp/lease*
while read line; do 
   if [[ $line =~ ^"lease {" ]]; then 
      LEASE=$(($LEASE+1))
   fi
   echo $line >> /tmp/lease$LEASE
done < $LEASES_FILE

# Remove not valid items
DATE=`date`
CUR=`date --date "$DATE" +%s`
for file in `ls /tmp/lease*`; do 
   DATE=`cat $file | grep expire | awk '{print $3" "$4}' | cut -f1 -d';'`
   REF=`date --date "$DATE" +%s`
   if [ $CUR -gt $REF ];
   then
      rm -rf $file
   else
      # Remove all others interfaces than eth0
      if [ `grep "interface \"eth0\"" $file | wc -l` -ne 1 ]; then
	 rm -rf $file
      fi
   fi	   
done

# Keep the last valid item 
if [ `ls /tmp/lease* | wc -l` -ge 1 ];
then
   FILE=`ls -tr /tmp/lease* | tail -1`
   FILENAME=`grep bootfile-name    $FILE | cut -f2 -d'"'`
   SERVNAME=`grep tftp-server-name $FILE | cut -f2 -d'"'` 
else
   echo "No valid item for eth0 interface"
   exit 1
fi

# Download file throught tftp
rm -rf $CONFFILE 
if [[ $FILENAME != "" && $SERVNAME != "" ]];
then
   echo "Try to download "$FILENAME" file from "$SERVNAME" server"
   logger -t $0 "Try to download "$FILENAME" file from "$SERVNAME" server"
   tftp $SERVNAME << ! 
bin
get $FILENAME $CONFFILE  
quit
!
   RET=$?
else
   echo "No valid filename ("$FILENAME") or server ("$SERVNAME")"
   logger -t $0 "No valid filename ("$FILENAME") or server ("$SERVNAME")"
   exit 1
fi

if [ $RET -ne 0 ]; 
then
   echo "Timout error during tftp"
   logger -t $0 "Timout error during tftp"
   exit 1
fi

# Check config file
if [ -e $CONFFILE ]; then
   if [ -s $CONFFILE ]; then
      # Check if the applyscript exist
      if [ -e $APPLISCRIPT ];
      then
         echo "Apply "$CONFFILE" file"
         logger -t $0 "Apply "$CONFFILE" file"
         $APPLISCRIPT
	 RET=$?
         logger -t $0 "exit "$RET
         exit $RET
      else
         echo $CONFFILE" not applied"
         logger -t $0 $CONFFILE" not applied"
         exit 1
      fi
   else
      logger -t $0 $CONFFILE" file is empty"
      exit 1
   fi
else
   echo "No "$CONFFILE" file"
   logger -t $0 "No "$CONFFILE" file"
   exit 1
fi

