#! /bin/sh

source /usr/bin/jtag_utils

FPGA_FOLDER="/acterna/storage/fpga/"
CABLE_NAME="tacb"

# Process arguments
Interface=0
[ $# -ge 1 ] && Interface=$(($1 - 1))

PROG_SPECIFIC=""
[ $# -ge 2 ] && PROG_SPECIFIC=$2

# Explore jtag chain ('jtag_clean' needs to be called before exitting)
jtag_detect "${CABLE_NAME}" "${Interface}"
[ $? -ne 0 ] && echo "Error detecting the JTAG chain of '${CABLE_NAME}'" && jtag_clean && exit 0

# Program each component with a file named with the ID
# If we are in POST Operation do not program but execute post op instead
Chain_Length=$(jtag_get_chain_length)
[ $? -ne 0 ] && echo "Error reading the Chain Length" && jtag_clean && exit 0

for jtag_index in $(seq 0 $((Chain_Length-1)))
do
	echo -e "TACB #$((Interface+1)) - Submodule #${jtag_index}"

	# Get the Device ID
	Device_Id=$(jtag_get_device_id ${jtag_index})
	[ $? -ne 0 ] && echo -e "\tError reading the Device ID" && jtag_clean && exit 0
	echo -e "\tDevice_Id: ${Device_Id}"

	# Program the device
	FLASH_COMMAND=""
	if [ -z "$PROG_SPECIFIC"  ]
	then
		FPGA_FILE_PATH="${FPGA_FOLDER}${Device_Id}"
		FPGA_FILE_PATH_MAJ=$(echo ${FPGA_FILE_PATH} | tr '[a-z]' '[A-Z]')
		FPGA_FILE_PATH_MIN=$(echo ${FPGA_FILE_PATH} | tr '[A-Z]' '[a-z]')
		if [ -e ${FPGA_FILE_PATH} ]
		then
			FLASH_COMMAND=$(cat ${FPGA_FILE_PATH})
		elif [ -e ${FPGA_FILE_PATH_MAJ} ]
		then
			FLASH_COMMAND=$(cat ${FPGA_FILE_PATH_MAJ})
		elif [ -e ${FPGA_FILE_PATH_MIN} ]
		then
			FLASH_COMMAND=$(cat ${FPGA_FILE_PATH_MIN})
		else
			echo -e "\tDevice ID \"${Device_Id}\" is not handled" && jtag_clean && exit 0
		fi
	else
		FLASH_COMMAND="svf ${PROG_SPECIFIC}"
	fi

	echo -e "\tFlash command is \"${FLASH_COMMAND}\""
	jtag_flash "${CABLE_NAME}" "${Interface}" "${jtag_index}" "${FLASH_COMMAND}"
	echo -e "\tFlash done"
done

jtag_clean
exit 0
