from __future__ import print_function
import os
import sys


def erase_eeprom(eeprompath):
  eepromsize = os.path.getsize(eeprompath)
  if eepromsize > 0:
    print("This may take awhile. Writing ", eepromsize, "bytes")
    ffdata = bytearray([0xff])*eepromsize
    eeprom = open(eeprompath, "wb")
    eeprom.write(ffdata)

if __name__ == '__main__':
  if len(sys.argv) > 1:
    erase_eeprom(sys.argv[1])
  else:
    print("usage: python", sys.argv[0], "eeprompath('/sys/devices/platform/30a30000.i2c/i2c-1/1-0051/eeprom')")

