#!/bin/bash
#
# This script is searching for CAA hardware requiring CAA solution to run.
#
#

CAA_SHOULD_RUN=0

# Wait for the scan to be completed
cat /sys/platform/uts_scan/ready

# Check if shim is present, if it is i2c busses should be set
if grep 0 -q /sys/platform/uts_scan/i2c_master_* ; then
  exit 1
fi

# Search for a CAA module
tail -n 2 /sys/platform/uts_scan/modules | grep CAA | tr -s "\t" " " | cut -d " " -f 3 | grep -v -x -q 0 && exit 0

exit 1
