#!/bin/bash

source /etc/otu_rfs_sync.conf # provide files to monitor
source /etc/otu/otuparts.sh

logfile=/var/log/otu_rfs_duplicate.log
DEST=

# $WATCHED_FILES_LIST
# $WATCHED_DIR_UPDATE_LIST

# Do not sync when duplicating
if $(readlink /sbin/init | grep -q systemd); then
    systemctl stop otu-rfs-sync.service
else
    /etc/init.d/otu_rfs_sync.sh stop
fi

DEST=$( mount | grep $ALT_PART | awk '{ print $3 }' )
if [[ -z "$DEST" ]]; then
    DEST=/mnt/fs/unused_part
fi    
[[ -d $DEST ]] || mkdir -p $DEST
mount | grep $ALT_PART || mount -o ro $ALT_PART $DEST
mount -o remount,rw $DEST

date > $logfile

for file in $WATCHED_FILES_LIST; do
    RET="KO"
    rsync -a $file $DEST/$file
    [[ $? -eq 0 ]] && RET="OK"
    if [[ "$file" != *"expired_licence.dat"* ]]; then
        echo "RFS: file = $file, duplication = $RET" >> $logfile
    else
        # on ne trace pas le fichier des licences expirées
        echo "RFS: EXPIRED = $RET" >> $logfile
    fi
    
done

for dir in $WATCHED_DIR_UPDATE_LIST; do
    RET="KO"
    rsync -a --delete ${dir}/ $DEST/${dir}/
    [[ $? -eq 0 ]] && RET="OK"
    echo "RFS: dir = $dir, duplication = $RET" >> $logfile
done

mount -o remount,ro $DEST
