#!/bin/bash
# SD OTU 8KV2 09/12/13
# usage: get-smartotu-backup {<mode [usb/ftp/hd(default)]> {<ftp-ip-addr> {<ftp-username> {<ftp-password>}}}}


RC=0

BACKUPSET_TAR_FILE_PREFIX="smartotu-backup-"

OTU=no

if [ -f /usr/lib/otu_functions ] ; then
    source /usr/lib/otu_functions
    is_cotu_hw
    if [ $? -eq 1 ] ; then
        OTU=yes
    fi
fi

MODE=$1
/usr/bin/test -z ${MODE} && MODE=hd

FTP_IPADDR=$2
/usr/bin/test -z ${FTP_IPADDR} && FTP_IPADDR=10.10.52.31

FTP_USER=$3
/usr/bin/test -z ${FTP_USER} && FTP_USER=upgrader

FTP_PASSWORD=$4
/usr/bin/test -z ${FTP_PASSWORD} && FTP_PASSWORD=password

TAR_FILE=$5
/usr/bin/test -z ${TAR_FILE} && TAR_FILE=${BACKUPSET_TAR_FILE_PREFIX}`/sbin/getserialnb`-$(date +%Y%m%d%H%M%S).tar.gz 

ADD_LOG_FILE="/var/log/get-smartotu-backup".$(date +%Y%m%d%H%M).log

if [ $OTU = "yes" ]
then
    # Create a get-otu-backupset log file with various tidbits of information...
    echo "--      Base `hostname` (`/sbin/getserialnb`) Backup (`date`)      --" >  ${ADD_LOG_FILE}
    echo " "                               >> ${ADD_LOG_FILE} 
    echo "----------------"                >> ${ADD_LOG_FILE}
    echo "CMD : ifconfig"                  >> ${ADD_LOG_FILE}
    echo " "                               >> ${ADD_LOG_FILE} 
    /sbin/ifconfig				           >> ${ADD_LOG_FILE}
    echo "----------------"                >> ${ADD_LOG_FILE} 
    echo "CMD : set"                       >> ${ADD_LOG_FILE}
    echo " "                               >> ${ADD_LOG_FILE} 
    set                                    >> ${ADD_LOG_FILE}
    echo "----------------"                >> ${ADD_LOG_FILE} 
    echo "CMD : fw_printenv"               >> ${ADD_LOG_FILE}
    echo " "                               >> ${ADD_LOG_FILE} 
    fw_printenv                            >> ${ADD_LOG_FILE}
    echo "----------------"                >> ${ADD_LOG_FILE} 
    echo "CMD : df"                        >> ${ADD_LOG_FILE}
    echo " "                               >> ${ADD_LOG_FILE} 
    /bin/df                                >> ${ADD_LOG_FILE}
    echo "----------------"                >> ${ADD_LOG_FILE} 
    echo "CMD : uptime"                    >> ${ADD_LOG_FILE}
    echo " "                               >> ${ADD_LOG_FILE} 
    /usr/bin/uptime   			           >> ${ADD_LOG_FILE}
	echo "----------------"            	>> ${ADD_LOG_FILE} 
	echo "CMD : getinfoversion Otu"		>> ${ADD_LOG_FILE}
    echo " " 
	/sbin/getinfoversion Otu	       	>> ${ADD_LOG_FILE}
else
    #get-otu-backupset is only used for otu
    exit 1    
fi

echo "Creating backup of the monitoring configuration for unit #`/sbin/getserialnb`"
tar -hzcvf  /user/harddisk/$TAR_FILE /otu/config/measure /otu/reference /acterna/storage/otu/communication /acterna/storage/otu/calibration /var/log/get-smartotu-backup*.log

if [ ! -f /user/harddisk/$TAR_FILE ]
then
    RC=1
fi
DF=`/bin/df | grep -wE "/var/volatile$" | awk '{ print $5 }' | cut -f1 -d '%'`

if [ $DF = "100" ]
then
   echo "Error: no space left!"
   RC=1
else
   if [ $MODE = "usb" ]
   then
     echo "Copy snapshot to usb flash memory"
     cp /user/harddisk/$TAR_FILE /user/usbflash/.
     let RC=RC+$?
   fi
      
   if [ $MODE = "ftp" ]
   then
      echo "Uploading snapshot to IP address '$FTP_IPADDR' with username '$FTP_USER' and password '$FTP_PASSWORD'"
      echo "with username '$FTP_USER' and password '$FTP_PASSWORD'"
      echo user                          > /tmp/ftpLogin
      echo $FTP_USER $FTP_PASSWORD      >> /tmp/ftpLogin
      echo binary                       >> /tmp/ftpLogin
      echo put /user/harddisk/$TAR_FILE $TAR_FILE >> /tmp/ftpLogin
      ftp -n -v $FTP_IPADDR < /tmp/ftpLogin
      let RC=RC+$?
   fi    
fi

# Cleanup temporary files
rm -f /tmp/ftpLogin /tmp/$TAR_FILE
rm -f ${ADD_LOG_FILE}

if [ $RC = 0 ]
then   
  #file can be downloaded by users which are not root
  chmod 644 /user/harddisk/$TAR_FILE
  
  #remove old backups on disk
  MAX=1
  FILES=($(ls -1 /user/harddisk | grep ${BACKUPSET_TAR_FILE_PREFIX} | sort))
  FILES_COUNT=${#FILES[@]}
  FILES_INDEX=0
  while [ $FILES_COUNT -gt $MAX ]
  do
    #never remove the current file
    if [ ${FILES[$FILES_INDEX]} != $TAR_FILE ]
    then
        rm -f /user/harddisk/${FILES[$FILES_INDEX]}
        FILES_COUNT=$(( $FILES_COUNT - 1 ))
    fi
    FILES_INDEX=$(( $FILES_INDEX + 1 ))    
  done
fi

# return 0 if success, positive value otherwise
exit $RC
