import QtQuick 2.3
import libfo 1.0
import "./UtilUiQt/Viavi_Colors.js" as VColor

Rectangle {
    id: container
    
    width: parent != undefined ? parent.width : 0
    height: isVisible ? rowHeigth : 0
    
    visible: isVisible
    
    // border.color: VColor.cViaviColorLogoPurple
    color: "transparent"
    
    property int textInputWidth: parent.width - headerWidth - headerSpacing
    property int textLength: 25
    property int textSize: 18
    property int headerWidth: 200
    property int headerSpacing: 4 
    property bool isError: false
    property string dataText: dataItem
    
    Component.onCompleted: displayMustToHave()
    
    onDataTextChanged: {
      value_id.text = dataText;
    }
    
    function dataValidated(value, key)
    {
        platform.getElfData(":config:Fiber_Optic:wizardRecordingInformation:dataValue:" + key + ":").value = value
    }
	
    function displayMustToHave() 
    {
    if ( ( isValid === false ) && ( isVisible != false ) ) // EPT 8134 : If the "Comment" field is empty, it should not have isError == true status, as it is not mandatory.
	  {
	  isError = true;
	  }
    else
	  {
	  isError = false;
	  }
    }
    
    function editText(txtOutput, validation) {   
        if (validation === true)
        {
            value_id.text = txtOutput
            dataValidated(value_id.text, key)
        }
        displayMustToHave();
        keyboard.editText.disconnect(editText);   
    }
    
    function editNumber(txtOutput, validation) {   
        if (validation === true)
        {
            value_id.text = txtOutput
            dataValidated(value_id.text, key)
        }
        displayMustToHave();        
        keypad.editText.disconnect(editNumber); 
    }
      
    Rectangle {
      anchors.fill: parent
      anchors.leftMargin: 10
      
      color: "transparent"
      
      clip: true
    
       Row {
           id: row_id
           spacing: headerSpacing
           height: parent.height
           width: parent.width
           
           Rectangle {
               //color: VColor.cViaviColorLightGray2 cViaviColorGray
               color: VColor.cViaviColorGray
               height: parent.height
               width: headerWidth
               
               clip: true
               
               Text {
                   id: header_text_id
                   text: label
                   anchors.fill: parent
                   anchors.leftMargin: 5
                   // color: VColor.cViaviColorBlack
                   color: VColor.cViaviColorWhite
                   
                   font.pixelSize: textSize
                   //font.bold: true
                   
                   clip: true
                   
                   wrapMode: Text.Wrap
                   verticalAlignment: Text.AlignVCenter
               }
               
               Image {
                    width: 20
                    height: 20
                  
                    visible: isError
                  
                    anchors.right: parent.right
                    anchors.rightMargin: 3
                    anchors.bottom: parent.bottom
                    anchors.bottomMargin: 3
                    
                    cache: false
                    asynchronous: true
                  
                    source: "/acterna/storage/look-and-feel/generic/Warning_Wizard.png"
                    fillMode: Image.PreserveAspectFit
   	    	   }
   	    	}
   	    	   
	    	   Rectangle {
               id: separatorContainer
               
               height: parent.height - 6
               width: 2
               
               visible: false

               anchors.verticalCenter: parent.verticalCenter
               
               color: VColor.cViaviColorLightGray2
            }
            
            Rectangle {
               height: parent.height
               width: parent.width - separatorContainer.width - headerWidth
               
               color: "transparent"
               
               MouseArea {
                  anchors.fill: parent
      
                  onClicked: {
                     switch(style)
                        {
                        case wizardRecordingInformation_res_recordType.enums.ertStringItem:
                           {
                           keyboard.editText.connect(editText);
                           openKeyBoard( header_text_id.text, value_id.text );                           
                           break;
                           }   
                        case wizardRecordingInformation_res_recordType.enums.ertIntItem:
                           {
                           keypad.editText.connect(editNumber);                           
                           openKeyPad( header_text_id.text, value_id.text, false, min, max );                           
                           break;
                           }
                        case wizardRecordingInformation_res_recordType.enums.ertRealItem:
                           {
                           keypad.editText.connect(editNumber);                           
                           openKeyPad( header_text_id.text, value_id.text, true, min, max );                           
                           break;
                           }
                        default:
                        case wizardRecordingInformation_res_recordType.enums.ertUnknownItem:
                           {
                           break;
                           }
                        }
                  }
               }
               
               Image {
			      id: editableMetaphor
			      width: 14
			      height: 14
			      anchors.verticalCenter: parent.verticalCenter
			      anchors.left: parent.left
			      source: "/acterna/storage/look-and-feel/generic/Icon_Settings.png"
			      fillMode: Image.PreserveAspectFit
			   }
               
               Text {
                   id: value_id
                   
                   anchors.fill: parent
                   anchors.leftMargin: 2 * editableMetaphor.width
                   
                   verticalAlignment: Text.AlignVCenter
                   
                   color: VColor.cViaviColorBlack
                   
                   font.pixelSize: textSize
                   text: dataText
               }
            }
       }
   }
}
