import QtQuick 2.3
import libfo 1.0
import "./UtilUiQt/Viavi_Colors.js" as VColor

Rectangle {
   id: container
   
   color: VColor.cViaviColorLightGray2
       
  Rectangle {
      id: loadWizard
      width: 650
      height: 100
      radius: 20
      color: VColor.cViaviColorLogoPurple

      anchors.horizontalCenter: parent.horizontalCenter
      anchors.bottom: parent.verticalCenter
      anchors.bottomMargin: 30

      Text {
		  color: VColor.cViaviColorWhite
		  anchors.fill: parent
		  text: wizardWindowManager_res_txtTestAuto.value
		  horizontalAlignment: Text.AlignHCenter
		  verticalAlignment:  Text.AlignVCenter
		  font.pixelSize: 30
      }
      
      MouseArea {
	  anchors.fill: parent
		  onClicked: {
              wizardWindowManager_act_closeConfigModeWindows.invokeWithStringArg("true")
		  }
      }
  }
  
  /* Separator */
  Rectangle {
    width: 300
    height: 6
    
    radius: 3
    
    color: VColor.cViaviColorGray
    
    anchors.centerIn: parent
  }
   
  Rectangle {
      id: loadConfig
      width: 650
      height: 100
      radius: 20
      color: VColor.cViaviColorLightBlue

      anchors.horizontalCenter: parent.horizontalCenter
      anchors.top: parent.verticalCenter
      anchors.topMargin: 30

      Text {
		  color: VColor.cViaviColorWhite
		  anchors.fill: parent
		  text: wizardWindowManager_res_txtLoadSmartConfig.value
		  horizontalAlignment: Text.AlignHCenter
		  verticalAlignment:  Text.AlignVCenter
		  font.pixelSize: 30
      }
      
      MouseArea {
	  anchors.fill: parent
		  onClicked: {
            wizardWindowManager_act_closeConfigModeWindows.invokeWithStringArg("false")
		  }
      }
  }

   Text {
       color: VColor.cViaviColorBlack
       anchors.top: parent.top
       anchors.right: parent.right
       anchors.margins: 10
       text: wizardWindowManager_res_txtWizardFilename.value
       horizontalAlignment: Text.AlignRight
       verticalAlignment:  Text.AlignVCenter
       font.pixelSize: 20
   }
}
