import QtQuick 2.5
import QtQuick.Layouts 1.1
import graph_plugin 1.0
import elf_plugin 1.0

import "ViaviStyle"

FiberContainer
{
    id: root
    
    height: linesContainer.height + 2 * linesContainer.anchors.topMargin

    property string focusedGraphBackendId: "0_" //default id for main graph
    property ElfData pointsXRangeEnd: platform.getElfData(':result:Fiber_Optic:trace:points' + focusedGraphBackendId + '0_xRangeEnd' + ':')
    property ElfData pointsXRangeBegin: platform.getElfData(':result:Fiber_Optic:trace:points' + focusedGraphBackendId + '0_xRangeBegin' + ':')
    property ElfData pointsYRangeEnd: platform.getElfData(':result:Fiber_Optic:trace:points' + focusedGraphBackendId + '0_yRangeEnd' + ':')
    property ElfData pointsYRangeBegin: platform.getElfData(':result:Fiber_Optic:trace:points' + focusedGraphBackendId + '0_yRangeBegin' + ':')
    property ElfData selectedIndex: platform.getElfData(':config:Fiber_Optic:trace:selectedIndex' + focusedGraphBackendId + ':')

    signal miniTraceClicked()

    FiberContainer{
        id: trace

        visible: miniCurve_res_miniCurveMode.value !== miniCurve_res_miniCurveMode.enums.ecNo_Mini_Curve
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        width: root.width / 5
        GraphView{
            anchors.fill: parent
            anchors.margins: ViaviStyle.layouts.borderSize
            id : graphId

            ValueAxis{
                id: xAxis
                objectName: "xAxis"
                alignment: Qt.AlignBottom
                margin: 0

                maxValue: miniCurve_res_miniCurveMode.value === miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result ?
                              pointsXRangeEnd.value :
                              miniCurve_res_minicurve_xRangeEnd.value
                minValue: miniCurve_res_miniCurveMode.value === miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result ?
                              pointsXRangeBegin.value :
                              miniCurve_res_minicurve_xRangeBegin.value
                visible: false

            }

            ValueAxis{
                id: yAxis
                objectName: "yAxis"
                alignment: Qt.AlignLeft
                margin: 0
                maxValue: miniCurve_res_miniCurveMode.value === miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result ?
                              pointsYRangeEnd.value :
                              miniCurve_res_minicurve_yRangeEnd.value
                minValue: miniCurve_res_miniCurveMode.value === miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result ?
                              pointsYRangeBegin.value :
                              miniCurve_res_minicurve_yRangeBegin.value
                visible: false
            }

            GraphPlot {
                id: reflections
                objectName: "minicurve"

                plotData: PlotPoints {
                    dbusAddress:  "gem.fiber.Fiber_Optic,:result:Fiber_Optic:miniCurve:minicurve"

                    axisY: yAxis
                    axisX: xAxis
                }
                antialiasing : false

                penColor: ViaviStyle.colors.activeColor
                plotStyle: GraphPlot.LinePlot

                maxLineWidth: 1//ViaviStyle.layouts.grapLineWidth
                minLineWidth: 1//ViaviStyle.layouts.grapLineWidth
                visible: miniCurve_res_miniCurveMode.value !== miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result
            }
            
            Repeater {
                id: graphRepeaterId
                model: trace_cfg_maxNumPlots.value

                GraphPlot {

                    property ElfData pointAsSegment: platform.getElfData(":result:Fiber_Optic:trace:pointsAsSegments" + focusedGraphBackendId + ":" + index + ":")

                    property ElfData groupIndex: platform.getElfData(":result:Fiber_Optic:trace:traceGroupIndex" + focusedGraphBackendId + ":" + index + ":")

                    plotData: PlotPoints {
                        dbusAddress:  "gem.fiber.Fiber_Optic,:result:Fiber_Optic:trace:points" + focusedGraphBackendId + "" + index
                        usePointsAsSegments: pointAsSegment.value

                        axisY: yAxis
                        axisX: xAxis
                    }

                    property int colorIndex : (groupIndex.value !== -1) ? groupIndex.value : index
                    visible: miniCurve_res_miniCurveMode.value === miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result
                             && selectedIndex.value === colorIndex

                    antialiasing : false

                    penColor: ViaviStyle.colors.activeColor
                    plotStyle: GraphPlot.LinePlot

                    maxLineWidth: 1//ViaviStyle.layouts.grapLineWidth
                    minLineWidth: 1//ViaviStyle.layouts.grapLineWidth
                }
            }
        }

        MouseArea{
            enabled: miniCurve_res_miniCurveMode.value === miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result
            anchors.fill: parent
            onClicked: root.miniTraceClicked()
        }
    }

    Rectangle {
        id: zoomLevelIndicator

        visible: miniCurve_res_miniCurveMode.value === miniCurve_res_miniCurveMode.enums.ecMini_Curve_Result

        width: trace.width * root.wScale
        height: trace.height * root.hScale

        x: trace.width * root.xScale
        y: trace.height * (1 - root.yScale) - zoomLevelIndicator.height
        border.color: ViaviStyle.colors.secondaryInfoColor
        color: "transparent"
    }

    Text{
    	id: lfdText
    	anchors.left: trace.left
    	anchors.bottom: trace.bottom

      visible: lfd_res_lfdVisible.value
    	color: lfd_res_lfdOn.value ? ViaviStyle.colors.mainInfoColor : "transparent"
    	font: ViaviStyle.layouts.largeFont

    	height: ViaviStyle.layouts.largeBoldFontMetrics.height
    	width: contentWidth

    	text: "LFD"
    }
    
    Image {
    	id: lfdIcon
   	anchors.horizontalCenter: trace.horizontalCenter
    	anchors.verticalCenter: trace.verticalCenter
      visible: lfd_res_lfdIcon.value

    	source: lfd_res_lfdIconPath.value

    	Text {
    		anchors.top: lfdIcon.bottom
    		anchors.horizontalCenter: lfdIcon.horizontalCenter

    		text: lfd_res_lfdIconTxt.value
    		font: ViaviStyle.layouts.mediumBoldFont
    		color: ViaviStyle.colors.mainInfoColor
    	}
    }

    property real xScale: 0
    property real yScale: 0
    property real wScale: 1
    property real hScale: 1
    
    function setTraceZoomLevel(xScale, yScale, wScale, hScale) {
        root.wScale = wScale
        root.hScale = hScale
        root.xScale = xScale
        root.yScale = yScale
    }

    function setGraphFocusedBackendId(graphBackendId){
        focusedGraphBackendId = graphBackendId
    }

    Item{
        id: linesContainer
        anchors.left: trace.visible ? trace.right : parent.left
        anchors.leftMargin: ViaviStyle.layouts.smallMargin
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layouts.borderSize
        anchors.right: alarmStatusRect.left
        anchors.rightMargin: ViaviStyle.layouts.smallMargin

        height: fileNameItem.height + leftTextColumn.height

        Item {
            id: fileNameItem

            anchors.left: parent.left
            anchors.top: parent.top
            anchors.right: dateText.left
            height: ViaviStyle.layouts.largeBoldFontMetrics.height

            Text{
                id: fileNameLabel

                anchors.left : parent.left

                color: ViaviStyle.colors.mainInfoColor
                font: ViaviStyle.layouts.largeBoldFont

                height: ViaviStyle.layouts.largeBoldFontMetrics.height
                width: contentWidth

                text: ViaviStyle.layouts.largeBoldFontMetrics.elidedText(
                            summaryinfo_res_fileName.value ? summaryinfo_res_fileName.value : summaryinfo_res_line3.value
                            , Text.ElideRight
                            , parent.width - unsavedLabelText.width
                            )
            }

            Text{
                id: unsavedLabelText
                anchors.left: fileNameLabel.right

                visible: !summaryinfo_res_fileSaved.value && !status_res_fileSummaryEnabled.value
                color: ViaviStyle.colors.mainInfoColor
                font: ViaviStyle.layouts.largeFont

                height: ViaviStyle.layouts.largeBoldFontMetrics.height
                width: contentWidth

                text: summaryinfo_res_unsavedLabel.value
            }
        }

        Text {
            id: dateText
            anchors.right: parent.right
            anchors.top: parent.top

            width: contentWidth

            color: ViaviStyle.colors.mainInfoColor
            font: ViaviStyle.layouts.largeFont

            text: summaryinfo_res_acqStart.value
            horizontalAlignment: Text.AlignRight
        }

        Column{
            id: leftTextColumn

            anchors.left: parent.left
            anchors.right: rightColumn.left
            anchors.top: fileNameItem.bottom

            Column {
                id: otdrInfo
                visible: status_res_otdrTabEnabled.value && !status_res_fileSummaryEnabled.value

                anchors.left: parent.left
                anchors.right: parent.right

                Item{
                    height: ViaviStyle.layouts.activeTextFontMetrics.height
                    anchors.left: parent.left
                    anchors.right: parent.right

                    Text{
                        color: ViaviStyle.colors.mainInfoColor
                        font: ViaviStyle.layouts.activeTextFont

                        text: summaryinfo_res_line3.value
                    }
                }

                Item{
                    anchors.left: parent.left
                    anchors.right: parent.right

                    //make this row use the full length of the summary info, the right element will be under the right column
                    //did not add those elements in the actuall right column in order to control all of these items visibility by the visibility of otdrInfo element
                    anchors.rightMargin: -rightColumn.width

                    height: ViaviStyle.layouts.activeTextFontMetrics.height

                    Text{
                        id: configText

                        anchors.left: parent.left
                        anchors.right: pulse.visible ? pulse.left : acqTime.left

                        anchors.rightMargin: 2 * ViaviStyle.layouts.largeMargin

                        color: ViaviStyle.colors.mainInfoColor
                        font: ViaviStyle.layouts.activeTextFont

                        elide: Text.ElideRight

                        text: summaryinfo_res_configFileName.value
                    }

                    Text{
                        id: pulse
                        anchors.right: acqTime.left
                        anchors.rightMargin: ViaviStyle.layouts.largeMargin

                        width: contentWidth

                        visible: summaryinfo_res_pulseValue.value

                        color: ViaviStyle.colors.mainInfoColor
                        font: ViaviStyle.layouts.activeTextFont

                        text: summaryinfo_res_pulseLabel.value
                              + ": " + summaryinfo_res_pulseValue.value
                    }

                    Text{
                        id: acqTime
                        anchors.right: parent.right

                        width: contentWidth
                        color: ViaviStyle.colors.mainInfoColor
                        font: ViaviStyle.layouts.activeTextFont

                        text: summaryinfo_res_acqTime.value
                    }
                }
            }

            Column {
                anchors.left : parent.left
                anchors.right : parent.right

                visible: !status_res_otdrTabEnabled.value || status_res_fileSummaryEnabled.value

                Text{
                    anchors.left : parent.left
                    anchors.right : parent.right

                    color: ViaviStyle.colors.mainInfoColor
                    font: ViaviStyle.layouts.activeTextFont

                    text: summaryinfo_res_line1.value
                }

                Text {
                    anchors.left : parent.left
                    anchors.right : parent.right

                    color: ViaviStyle.colors.mainInfoColor
                    font: ViaviStyle.layouts.activeTextFont

                    text: summaryinfo_res_line2.value
                }
            }
        }

        Item {
            id: rightColumn
            anchors.right: parent.right
            anchors.top: fileNameItem.bottom
            anchors.bottom: parent.bottom

            width: Math.max(dateText.width, directionText.width)

            Text{
                id: directionText
                anchors.right: parent.right
                anchors.top: parent.top

                width: Math.min ( linesContainer.width / 3 , ViaviStyle.layouts.activeTextFontMetrics.advanceWidth( text )
                                 + ViaviStyle.layouts.activeTextFontMetrics.maximumCharacterWidth )

                color: ViaviStyle.colors.mainInfoColor
                font: ViaviStyle.layouts.activeTextFont

                text: summaryinfo_res_measDir.value
                horizontalAlignment: Text.AlignRight
                wrapMode: Text.Wrap
            }
        }
    }


    /* Alarm status for file */
    Rectangle {

        id: alarmStatusRect
        visible: summaryinfo_res_alarmStatus.value !== 0

        width: parent.height
        height: parent.height

        anchors.right : parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom

        border.width: 1
        border.color: ViaviStyle.colors.borderColor

        Image {

            anchors.fill: parent
            anchors.topMargin: 5
            anchors.bottomMargin: 5

            source: summaryinfo_res_alarmStatus.value === -1 ? ViaviStyle.images.iconFailedAlarmStatus : ViaviStyle.images.iconPassedAlarmStatus
            fillMode: Image.PreserveAspectFit
            smooth: true
        }
    }
}


