import QtQuick 2.5
import "ViaviStyle"

FiberContainer {

    height: ViaviStyle.layouts.mediumMargin
            + ViaviStyle.layouts.numericValueFontMetric.height
            + ViaviStyle.layouts.mediumMargin

    function getDataModel() {
        return numericdisplay_res_dataTable.value
    }

    Item {
        id: realtimeComboBoxItem
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.left:  parent.left
        anchors.leftMargin: ViaviStyle.layouts.largeMargin
        width: parent.width * 0.4

        Text {
            id: realtimeComboBoxText

            anchors.verticalCenter: parent.verticalCenter
            anchors.left: parent.left

            text: numericdisplay_res_testLabelText.value + ':' //'Test:'
            font: ViaviStyle.layouts.largeFont
            color: ViaviStyle.colors.mainInfoColor
        }

        FiberComboBox {

            anchors.verticalCenter: parent.verticalCenter
            anchors.left: realtimeComboBoxText.right
            anchors.leftMargin: ViaviStyle.layouts.mediumMargin

            model: numericdisplay_res_averageMeasList.value
            textRole: 'text'
            onCurrentIndexChanged: numericdisplay_cfg_averageMeasChoice.value = currentIndex
            Component.onCompleted: currentIndex = numericdisplay_cfg_averageMeasChoice.value
        }
    }

    Item {
        anchors.verticalCenter: parent.verticalCenter
        anchors.left:  realtimeComboBoxItem.right
        anchors.leftMargin: ViaviStyle.layouts.mediumMargin
        height: realtimeMainValue.contentHeight

        Text {
            id: modeLabel

            anchors.left: parent.left
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2 * ViaviStyle.layouts.smallMargin

            text: getDataModel().mode + '  '
            font: ViaviStyle.layouts.numericConfigFont
            color: ViaviStyle.colors.mainInfoColor
        }

        Text {
            id: realtimeMainValue
            anchors.verticalCenter: parent.verticalCenter
            anchors.left: modeLabel.right
            anchors.leftMargin: ViaviStyle.layouts.largeMargin

            readonly property string noValueMarkerStr: '- - - -'
            text: {
                if (getDataModel().active) {
                    return getDataModel().statusAndSign + getDataModel().value.toFixed(3)
                }
                else {
                    return noValueMarkerStr
                }
            }
            font: ViaviStyle.layouts.numericValueFont
            color: ViaviStyle.colors.mainInfoColor
        }

        Text {
            id: mainUnit

            anchors.left: realtimeMainValue.right
            anchors.leftMargin: ViaviStyle.layouts.largeMargin
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2 * ViaviStyle.layouts.smallMargin

            text: getDataModel().unit
            font: ViaviStyle.layouts.numericConfigFont
            color: ViaviStyle.colors.mainInfoColor
        }
    }
}
